/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.experiment;

import jasima.core.experiment.AbortingExperiment;
import jasima.core.experiment.AbstractMultiExperiment;
import jasima.core.experiment.Experiment;
import jasima.core.util.MsgCategory;
import jasima.core.util.TypeUtil;
import jasima.core.util.Util;
import jasima.core.util.ValueStore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class AbstractMultiConfExperiment
extends AbstractMultiExperiment {
    private static final long serialVersionUID = 8651960788951812186L;
    public static final String KEY_EXPERIMENT = "@";
    public static final String FACTORS = "@factors";
    private Experiment baseExperiment = null;
    private ConfigurationValidator configurationValidator = null;
    protected int numConfs = 0;

    @Override
    public void init() {
        this.numConfs = 0;
        if (this.getBaseExperiment() == null) {
            throw new IllegalArgumentException("Please set a base experiment.");
        }
        super.init();
    }

    @Override
    protected abstract void createExperiments();

    @Nullable
    protected Experiment createExperimentForConf(Map<String, Object> conf) {
        if (!this.isValidConfiguration(conf)) {
            return null;
        }
        Experiment expForConf = null;
        ++this.numConfs;
        try {
            expForConf = this.doCreate(conf);
            List<Map.Entry<String, Object>> entries = this.sortConfEntries(conf);
            this.rememberFactorValues(expForConf, entries);
            this.setProperties(expForConf, entries);
        }
        catch (Exception e) {
            String msg = "error creating configuration " + conf + ": " + (e.getMessage() == null ? e.toString() : e.getMessage()) + " (" + e.getClass().getSimpleName() + ")";
            this.print(MsgCategory.ERROR, msg);
            this.print(MsgCategory.DEBUG, "%s", new Object(){

                public String toString() {
                    return Util.exceptionToString(e);
                }
            });
            AbortingExperiment abortingExperiment = new AbortingExperiment(msg, e);
            ValueStore.copy(expForConf, abortingExperiment, FACTORS);
            abortingExperiment.setName(expForConf.getName());
            expForConf = abortingExperiment;
        }
        return expForConf;
    }

    protected Experiment doCreate(Map<String, Object> conf) {
        Experiment e = conf.containsKey(KEY_EXPERIMENT) ? ((Experiment)conf.get(KEY_EXPERIMENT)).clone() : this.getBaseExperiment().clone();
        this.configureRunExperiment(e);
        return e;
    }

    private void rememberFactorValues(Experiment e, List<Map.Entry<String, Object>> entries) {
        for (Map.Entry<String, Object> p : entries) {
            if (p.getKey().equals(KEY_EXPERIMENT)) continue;
            ArrayList<String> fs = (ArrayList<String>)e.valueStoreGet(FACTORS);
            if (fs == null) {
                fs = new ArrayList<String>();
                e.valueStorePut(FACTORS, fs);
            }
            fs.add(p.getKey() + "=" + p.getValue());
        }
    }

    private List<Map.Entry<String, Object>> sortConfEntries(Map<String, Object> conf) {
        ArrayList<Map.Entry<String, Object>> entries = new ArrayList<Map.Entry<String, Object>>(conf.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                String b;
                String a = o1.getKey();
                if (a == (b = o2.getKey())) {
                    return 0;
                }
                if (a == null) {
                    return -1;
                }
                if (b == null) {
                    return 1;
                }
                return a.length() - b.length();
            }
        });
        return entries;
    }

    protected void setProperties(Experiment e, List<Map.Entry<String, Object>> entries) {
        for (Map.Entry<String, Object> p : entries) {
            if (p.getKey().equals(KEY_EXPERIMENT)) continue;
            if (p.getValue() != null && p.getValue() instanceof ComplexFactorSetter) {
                ((ComplexFactorSetter)p.getValue()).configureExperiment(e);
                continue;
            }
            TypeUtil.setPropertyValue(e, p.getKey(), TypeUtil.cloneIfPossible(p.getValue()));
        }
    }

    protected boolean isValidConfiguration(Map<String, Object> conf) {
        if (this.getConfigurationValidator() == null) {
            return true;
        }
        return this.getConfigurationValidator().isValid(this.getBaseExperiment(), conf);
    }

    @Override
    protected final String prefix() {
        return "conf";
    }

    @Override
    public int getNumExperiments() {
        return this.numConfs;
    }

    public Experiment getBaseExperiment() {
        return this.baseExperiment;
    }

    public void setBaseExperiment(Experiment baseExperiment) {
        this.baseExperiment = baseExperiment;
    }

    public ConfigurationValidator getConfigurationValidator() {
        return this.configurationValidator;
    }

    public void setConfigurationValidator(ConfigurationValidator configurationValidator) {
        this.configurationValidator = configurationValidator;
    }

    @Override
    public AbstractMultiConfExperiment clone() {
        AbstractMultiConfExperiment e = (AbstractMultiConfExperiment)super.clone();
        if (this.baseExperiment != null) {
            e.baseExperiment = this.baseExperiment.clone();
        }
        return e;
    }

    @FunctionalInterface
    public static interface ConfigurationValidator
    extends Serializable {
        public boolean isValid(Experiment var1, Map<String, Object> var2);
    }

    @FunctionalInterface
    public static interface ComplexFactorSetter
    extends Serializable {
        public void configureExperiment(Experiment var1);
    }
}

