/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.expExecution;

import jasima.core.expExecution.ExperimentExecutor;
import jasima.core.experiment.Experiment;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPoolExecutor
extends ExperimentExecutor {
    public static final String POOL_SIZE_SETTING = ThreadPoolExecutor.class.getName() + ".numThreads";
    private Map<Integer, ExecutorService> insts = new HashMap<Integer, ExecutorService>();

    @Override
    public ExecutorService experimentExecutor(Experiment e, Experiment parent) {
        return this.getExecutorInstance(e.nestingLevel());
    }

    @Override
    public synchronized void shutdownNow() {
        for (ExecutorService inst : this.insts.values()) {
            inst.shutdownNow();
        }
        this.insts.clear();
    }

    private synchronized ExecutorService getExecutorInstance(int nestingLevel) {
        ExecutorService inst = this.insts.get(nestingLevel);
        if (inst == null) {
            inst = this.createExecService(nestingLevel);
            this.insts.put(nestingLevel, inst);
        }
        return inst;
    }

    private ExecutorService createExecService(final int nestingLevel) {
        int numThreads = Runtime.getRuntime().availableProcessors();
        String sizeStr = System.getProperty(POOL_SIZE_SETTING);
        if (sizeStr != null) {
            numThreads = Integer.parseInt(sizeStr.trim());
        }
        ThreadFactory threadFactory = new ThreadFactory(){
            final ThreadFactory defFactory = Executors.defaultThreadFactory();
            final AtomicInteger numCreated = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = this.defFactory.newThread(r);
                t.setDaemon(true);
                t.setName("jasimaWorker-" + nestingLevel + "-" + this.numCreated.addAndGet(1));
                return t;
            }
        };
        return Executors.newFixedThreadPool(numThreads, threadFactory);
    }
}

