/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.expExecution;

import jasima.core.expExecution.ThreadPoolExecutor;
import jasima.core.experiment.Experiment;
import jasima.core.experiment.ExperimentCompletableFuture;
import jasima.core.util.TypeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;

public abstract class ExperimentExecutor {
    public static final String EXECUTOR_FACTORY = ExperimentExecutor.class.getName();
    public static final Class<? extends ExperimentExecutor> execFactoryImpl = TypeUtil.getClassFromSystemProperty(EXECUTOR_FACTORY, ExperimentExecutor.class, ThreadPoolExecutor.class);

    public static ExperimentExecutor getExecutor() {
        return ExecHolder.instance;
    }

    private static ExperimentExecutor createExecutor() {
        final ExperimentExecutor result = TypeUtil.createInstance(execFactoryImpl);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                result.shutdownNow();
            }
        });
        return result;
    }

    public abstract void shutdownNow();

    public abstract ExecutorService experimentExecutor(Experiment var1, @Nullable Experiment var2);

    public static Collection<ExperimentCompletableFuture> runAllExperiments(Collection<? extends Experiment> es, Experiment parent) {
        ArrayList<ExperimentCompletableFuture> res = new ArrayList<ExperimentCompletableFuture>(es.size());
        for (Experiment experiment : es) {
            res.add(ExperimentExecutor.runExperimentAsync(experiment, parent));
        }
        return res;
    }

    public static ExperimentCompletableFuture runExperimentAsync(Experiment e, Experiment parent) {
        return ExperimentExecutor.runExperimentAsync(e, parent, ExperimentExecutor.getExecutor().experimentExecutor(e, parent));
    }

    public static ExperimentCompletableFuture runExperimentAsync(Experiment e, Experiment parent, ExecutorService es) {
        return new ExperimentCompletableFuture(e, es);
    }

    static /* synthetic */ ExperimentExecutor access$000() {
        return ExperimentExecutor.createExecutor();
    }

    private static class ExecHolder {
        static final ExperimentExecutor instance = ExperimentExecutor.access$000();

        private ExecHolder() {
        }
    }
}

