/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.test;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.SeleniumException;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.jangaroo.jooc.mvnplugin.test.PhantomJsTestRunner;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JooTestMojo
extends AbstractMojo {
    private static final int MAX_JETTY_START_ATTEMPTS = 3;
    private MavenProject project;
    private File outputDirectory;
    private File testOutputDirectory;
    private File testSourceDirectory;
    private String testsHtml;
    private List<Resource> testResources;
    private boolean skip;
    private boolean skipTests;
    private File testResultOutputDirectory;
    private String testResultFileName;
    private int jooUnitJettyPortUpperBound = 10200;
    private int jooUnitJettyPortLowerBound = 10100;
    private int jooUnitTestExecutionTimeout = 30000;
    private String jooUnitSeleniumRCHost = "localhost";
    private int jooUnitSeleniumRCPort = 4444;
    private String jooUnitSeleniumBrowserStartCommand = "*firefox";
    private boolean testFailureIgnore;
    private String phantomBin;
    private String phantomTestRunner;
    private String phantomTestSuite;
    private String phantomArgs;

    protected boolean isTestAvailable() {
        for (Resource r : this.testResources) {
            File testFile = new File(r.getDirectory(), this.testsHtml);
            if (!testFile.exists()) continue;
            return true;
        }
        this.getLog().info((CharSequence)("The tests.html file '" + this.testsHtml + "' could not be found. Skipping."));
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipTests) return;
        PhantomJsTestRunner phantomJsTestRunner = new PhantomJsTestRunner(this.phantomBin, new File(this.testOutputDirectory, "META-INF/resources"), this.phantomTestRunner, this.phantomTestSuite, this.phantomArgs, this.jooUnitTestExecutionTimeout, this.getLog());
        this.getLog().info((CharSequence)("trying to run phantomjs first: " + phantomJsTestRunner.toString()));
        if (this.phantomTestSuite != null && phantomJsTestRunner.isTestAvailable() && phantomJsTestRunner.canRun()) {
            try {
                boolean exitCode = phantomJsTestRunner.execute();
                String testResultXml = phantomJsTestRunner.getTestResult();
                this.writeResultToFile(testResultXml);
                this.evalTestOutput(testResultXml);
                if (exitCode) return;
                this.signalFailure();
                return;
            }
            catch (CommandLineException e) {
                throw this.wrap((Exception)((Object)e));
            }
            catch (IOException e) {
                throw this.wrap(e);
            }
            catch (ParserConfigurationException e) {
                throw this.wrap(e);
            }
            catch (SAXException e) {
                throw this.wrap(e);
            }
        } else {
            if (!this.isTestAvailable()) return;
            this.executeSelenium();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeSelenium() throws MojoExecutionException, MojoFailureException {
        String url;
        this.jooUnitSeleniumRCHost = System.getProperty("SELENIUM_RC_HOST", this.jooUnitSeleniumRCHost);
        try {
            InetAddress.getAllByName(this.jooUnitSeleniumRCHost);
        }
        catch (UnknownHostException e) {
            throw new MojoExecutionException("Cannot resolve host " + this.jooUnitSeleniumRCHost + ". Please specify a host running the selenium remote control or skip tests" + " by -DskipTests", (Exception)e);
        }
        this.getLog().info((CharSequence)("JooTest report directory: " + this.testResultOutputDirectory.getAbsolutePath()));
        File testWebAppDirectory = new File(this.testOutputDirectory, "META-INF/resources");
        this.getLog().info((CharSequence)("Using base directory " + testWebAppDirectory.getAbsolutePath()));
        try {
            url = testWebAppDirectory.toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("should not happen: could not build test base directory file URL!");
        }
        DefaultSelenium selenium = new DefaultSelenium(this.jooUnitSeleniumRCHost, this.jooUnitSeleniumRCPort, this.jooUnitSeleniumBrowserStartCommand, url);
        try {
            selenium.start();
            String testsHtmlUrl = url + "/" + this.testsHtml.replace(File.separatorChar, '/');
            this.getLog().debug((CharSequence)("Opening " + testsHtmlUrl));
            selenium.open(testsHtmlUrl);
            this.getLog().debug((CharSequence)("Waiting for test results for " + this.jooUnitTestExecutionTimeout + "ms ..."));
            selenium.waitForCondition("selenium.browserbot.getCurrentWindow().result != null || selenium.browserbot.getCurrentWindow().classLoadingError != null", "" + this.jooUnitTestExecutionTimeout);
            String classLoadingError = selenium.getEval("selenium.browserbot.getCurrentWindow().classLoadingError");
            if (classLoadingError != null && !classLoadingError.equals("null")) {
                throw new MojoExecutionException(classLoadingError);
            }
            String testResultXml = selenium.getEval("selenium.browserbot.getCurrentWindow().result");
            this.writeResultToFile(testResultXml);
            this.evalTestOutput(testResultXml);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot write test results to file", (Exception)e);
        }
        catch (ParserConfigurationException e) {
            throw new MojoExecutionException("Cannot create a simple XML Builder", (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Cannot parse test result", (Exception)e);
        }
        catch (SeleniumException e) {
            if (!this.testFailureIgnore) {
                throw new MojoExecutionException("Selenium setup failure", (Exception)((Object)e));
            }
            this.getLog().warn((CharSequence)"Selenium setup failure", (Throwable)e);
        }
        finally {
            selenium.stop();
        }
    }

    protected List<File> findJars() throws DependencyResolutionRequiredException {
        ArrayList<File> jars = new ArrayList<File>();
        for (Object jarUrl : this.project.getTestClasspathElements()) {
            File file = new File((String)jarUrl);
            if (file.isFile()) {
                jars.add(file);
                this.getLog().info((CharSequence)("Test classpath: " + jarUrl));
                continue;
            }
            this.getLog().info((CharSequence)("Ignoring test classpath: " + jarUrl));
        }
        return jars;
    }

    private org.eclipse.jetty.util.resource.Resource toResource(File file) throws MojoExecutionException {
        try {
            return org.eclipse.jetty.util.resource.Resource.newResource((File)file);
        }
        catch (IOException e) {
            throw this.wrap(e);
        }
    }

    void writeResultToFile(String testResultXml) throws IOException {
        File result = new File(this.testResultOutputDirectory, this.getTestResultFileName());
        FileUtils.writeStringToFile((File)result, (String)testResultXml);
        if (!result.setLastModified(System.currentTimeMillis())) {
            this.getLog().warn((CharSequence)("could not set modification time of file " + result));
        }
    }

    private String getTestResultFileName() {
        if (this.testResultFileName != null) {
            return this.testResultFileName;
        }
        String result = this.phantomTestSuite != null ? this.phantomTestSuite : "TEST-" + this.project.getArtifactId();
        return result + ".xml";
    }

    private MojoExecutionException wrap(Exception e) {
        return new MojoExecutionException(e.toString(), e);
    }

    void evalTestOutput(String testResultXml) throws ParserConfigurationException, IOException, SAXException, MojoFailureException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = documentBuilderFactory.newDocumentBuilder();
        StringReader inStream = new StringReader(testResultXml);
        InputSource inSource = new InputSource(inStream);
        Document d = dBuilder.parse(inSource);
        NodeList nl = d.getChildNodes();
        NamedNodeMap namedNodeMap = nl.item(0).getAttributes();
        String failures = namedNodeMap.getNamedItem("failures").getNodeValue();
        String errors = namedNodeMap.getNamedItem("errors").getNodeValue();
        String tests = namedNodeMap.getNamedItem("tests").getNodeValue();
        String time = namedNodeMap.getNamedItem("time").getNodeValue();
        String name = namedNodeMap.getNamedItem("name").getNodeValue();
        this.getLog().info((CharSequence)(name + " tests run: " + tests + ", Failures: " + failures + ", Errors: " + errors + ", time: " + time + " ms"));
        if (Integer.parseInt(errors) > 0 || Integer.parseInt(failures) > 0) {
            this.getLog().info((CharSequence)testResultXml);
            this.signalFailure();
        }
    }

    private void signalFailure() throws MojoFailureException {
        if (!this.testFailureIgnore) {
            throw new MojoFailureException("There are test failures");
        }
    }

    private Server startJetty(Handler handler) throws MojoExecutionException {
        if (this.jooUnitJettyPortUpperBound != this.jooUnitJettyPortLowerBound) {
            int count = 0;
            Random r = new Random(System.currentTimeMillis());
            while (true) {
                int jooUnitJettyPort = r.nextInt(this.jooUnitJettyPortUpperBound - this.jooUnitJettyPortLowerBound) + this.jooUnitJettyPortLowerBound;
                Server server = new Server(jooUnitJettyPort);
                try {
                    server.setHandler(handler);
                    server.start();
                    return server;
                }
                catch (Exception e) {
                    boolean retry;
                    boolean bl = retry = ++count < 3;
                    if (retry) {
                        this.getLog().info((CharSequence)String.format("Failed starting Jetty on port %d failed. Retrying ...", jooUnitJettyPort));
                    } else {
                        this.getLog().error((CharSequence)String.format("Failed starting Jetty on port %d failed. Stop retrying!!", jooUnitJettyPort));
                    }
                    this.stopServerIgnoreException(server);
                    if (retry) continue;
                    throw new MojoExecutionException("Cannot start jetty server", e);
                }
                break;
            }
        }
        Server server = new Server(this.jooUnitJettyPortLowerBound);
        try {
            server.setHandler(handler);
            server.start();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Failed starting Jetty on port " + this.jooUnitJettyPortLowerBound + " failed."));
            this.stopServerIgnoreException(server);
            throw new MojoExecutionException("Cannot start jetty server on port " + this.jooUnitJettyPortLowerBound, e);
        }
        return server;
    }

    private void stopServerIgnoreException(Server server) {
        try {
            server.stop();
        }
        catch (Exception e1) {
            this.getLog().error((CharSequence)"Stopping Jetty failed. Never mind.");
        }
    }

    public void setSkip(boolean b) {
        this.skip = b;
    }

    public void setSkipTests(boolean b) {
        this.skipTests = b;
    }

    public void setTestSourceDirectory(File f) {
        this.testSourceDirectory = f;
    }

    public void setTestResources(ArrayList<Resource> resources) {
        this.testResources = resources;
    }

    public void setTestFailureIgnore(boolean b) {
        this.testFailureIgnore = b;
    }

    public void setTestOutputDirectory(File testOutputDirectory) {
        this.testOutputDirectory = testOutputDirectory;
    }
}

