/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.jangaroo.jooc.mvnplugin.PackageApplicationMojo;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.archiver.ArchiveFileFilter;
import org.codehaus.plexus.archiver.ArchiveFilterException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.util.FileUtils;

public class JooGenerateTestResourcesMojo
extends PackageApplicationMojo {
    private File outputDirectory;
    private File testPackageSourceDirectory;
    private File testOutputDirectory;
    private boolean skip;
    private boolean skipTests;
    private List<Resource> testResources;
    private ZipUnArchiver unarchiver;

    @Override
    public File getPackageSourceDirectory() {
        return "jangaroo".equals(this.project.getPackaging()) ? this.outputDirectory : this.testPackageSourceDirectory;
    }

    protected boolean isTestAvailable() {
        return true;
    }

    public void unpack(File target) throws ArchiverException {
        this.unarchiver.setOverwrite(false);
        this.unarchiver.setArchiveFilters(Collections.singletonList(new MetaInfResourcesArchiveFilter()));
        Set<Artifact> dependencies = this.getArtifacts();
        for (Artifact dependency : dependencies) {
            this.getLog().debug((CharSequence)("Dependency: " + dependency.getGroupId() + ":" + dependency.getArtifactId() + "type: " + dependency.getType()));
            if (dependency.isOptional() || !"jar".equals(dependency.getType())) continue;
            this.getLog().debug((CharSequence)("Unpacking jangaroo dependency [" + dependency.toString() + "]"));
            this.unarchiver.setSourceFile(dependency.getFile());
            this.unpack(dependency, target);
        }
    }

    public void unpack(Artifact artifact, File target) throws ArchiverException {
        this.unarchiver.setSourceFile(artifact.getFile());
        if (target.mkdirs()) {
            this.getLog().debug((CharSequence)("created unarchiver target directory " + target));
        }
        this.unarchiver.setDestDirectory(target);
        this.unarchiver.setOverwrite(false);
        try {
            this.unarchiver.extract();
        }
        catch (Exception e) {
            throw new ArchiverException("Failed to extract javascript artifact to " + target, (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException {
        if (!this.skip && !this.skipTests) {
            try {
                if (!this.isTestAvailable()) return;
                this.getLog().info((CharSequence)("Unpacking jangaroo dependencies to " + this.testOutputDirectory));
                this.unpack(this.testOutputDirectory);
                File webappDirectory = new File(this.testOutputDirectory, "META-INF/resources");
                this.createWebapp(webappDirectory);
                this.getLog().info((CharSequence)("Copying output from " + this.outputDirectory.getAbsolutePath() + " to " + this.testOutputDirectory.getAbsolutePath() + "..."));
                FileUtils.copyDirectoryStructureIfModified((File)this.outputDirectory, (File)this.testOutputDirectory);
                for (Resource r : this.testResources) {
                    File testResourceDirectory = new File(r.getDirectory());
                    if (!testResourceDirectory.exists()) continue;
                    this.getLog().info((CharSequence)("Copying resources from " + r.getDirectory() + " to " + webappDirectory.getAbsolutePath() + "..."));
                    FileUtils.copyDirectoryStructureIfModified((File)testResourceDirectory, (File)webappDirectory);
                }
                return;
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Cannot unpack jangaroo dependencies", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot copy jangaroo files/ generate html test page", (Exception)e);
            }
        } else {
            this.getLog().info((CharSequence)"Skipping generation of test resources");
        }
    }

    @Override
    protected void writeThisJangarooModuleScript(File scriptDirectory, Writer jangarooApplicationWriter, Writer jangarooApplicationAllWriter) throws IOException {
        super.writeThisJangarooModuleScript(scriptDirectory, jangarooApplicationWriter, jangarooApplicationAllWriter);
        this.writeModule(scriptDirectory, this.project.getGroupId(), this.project.getArtifactId() + "-test", this.project.getVersion(), jangarooApplicationWriter, jangarooApplicationAllWriter);
    }

    private static class MetaInfResourcesArchiveFilter
    implements ArchiveFileFilter {
        private MetaInfResourcesArchiveFilter() {
        }

        public boolean include(InputStream dataStream, String entryName) throws ArchiveFilterException {
            return entryName.startsWith("META-INF/resources");
        }
    }
}

