/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.BlockStatement;
import net.jangaroo.jooc.ast.Catch;
import net.jangaroo.jooc.ast.KeywordStatement;

public class TryStatement
extends KeywordStatement {
    private BlockStatement block;
    private List<Catch> catches;
    private JooSymbol symFinally;
    private BlockStatement finallyBlock;

    public TryStatement(JooSymbol symTry, BlockStatement block, List<Catch> catches) {
        this(symTry, block, catches, null, null);
    }

    public TryStatement(JooSymbol symTry, BlockStatement block, List<Catch> catches, JooSymbol symFinally, BlockStatement finallyBlock) {
        super(symTry);
        this.block = block;
        this.catches = catches;
        this.symFinally = symFinally;
        this.finallyBlock = finallyBlock;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.block, this.catches, this.finallyBlock);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitTryStatement(this);
    }

    @Override
    public void scope(Scope scope) {
        this.getBlock().scope(scope);
        this.scope(this.getCatches(), scope);
        if (this.getFinallyBlock() != null) {
            this.getFinallyBlock().scope(scope);
        }
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        this.getBlock().analyze(this);
        this.analyze(this, this.getCatches());
        if (this.getFinallyBlock() != null) {
            this.getFinallyBlock().analyze(this);
        }
    }

    public BlockStatement getBlock() {
        return this.block;
    }

    public List<Catch> getCatches() {
        return this.catches;
    }

    public JooSymbol getSymFinally() {
        return this.symFinally;
    }

    public BlockStatement getFinallyBlock() {
        return this.finallyBlock;
    }
}

