/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.LiteralExpr;
import net.jangaroo.jooc.ast.NodeImplBase;

public class AnnotationParameter
extends NodeImplBase {
    private Ide optName;
    private JooSymbol optSymEq;
    private LiteralExpr value;
    private CompilationUnit compilationUnit;
    private Annotation parentAnnotation;

    public AnnotationParameter(Ide optName, JooSymbol optSymEq, LiteralExpr value) {
        this.optName = optName;
        this.optSymEq = optSymEq;
        this.value = value;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.optName, this.value);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitAnnotationParameter(this);
    }

    public Annotation getParentAnnotation() {
        return this.parentAnnotation;
    }

    public void setParentAnnotation(Annotation parentAnnotation) {
        this.parentAnnotation = parentAnnotation;
    }

    @Override
    public void scope(Scope scope) {
        if (this.getValue() != null) {
            this.getValue().scope(scope);
            this.compilationUnit = scope.getCompilationUnit();
        }
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        if (this.getValue() != null) {
            this.getValue().analyze(this);
            String metaName = this.parentAnnotation.getMetaName();
            if ("Embed".equals(metaName) && this.getOptName() != null && "source".equals(this.getOptName().getName())) {
                JooSymbol valueSymbol = this.getValue().getSymbol();
                if (valueSymbol.sym != 98) {
                    throw new CompilerError(valueSymbol, "The source parameter of an [Embed] annotation must be a string literal");
                }
                String text = valueSymbol.getText();
                String quote = text.substring(0, 1);
                String source = (String)valueSymbol.getJooValue();
                String absoluteSource = this.compilationUnit.addResourceDependency(source);
                this.getValue().setValue(new JooSymbol(valueSymbol.sym, valueSymbol.getFileName(), valueSymbol.getLine(), valueSymbol.getColumn(), valueSymbol.getWhitespace(), quote + absoluteSource + quote, absoluteSource));
            }
        }
    }

    @Override
    public JooSymbol getSymbol() {
        return this.getOptName() == null ? this.getValue().getSymbol() : this.getOptName().getSymbol();
    }

    public Ide getOptName() {
        return this.optName;
    }

    public JooSymbol getOptSymEq() {
        return this.optSymEq;
    }

    public LiteralExpr getValue() {
        return this.value;
    }
}

