/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.xml;

import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PreserveLineNumberHandler
extends DefaultHandler {
    public static final String LINE_NUMBER_KEY_NAME = "lineNumber";
    private final Stack<Element> elementStack = new Stack();
    private final StringBuilder textBuffer = new StringBuilder();
    private Document doc;
    private Locator locator;

    public PreserveLineNumberHandler(Document doc) {
        this.doc = doc;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.addTextIfNeeded();
        Element el = this.doc.createElementNS(uri, qName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            el.setAttributeNS(attributes.getURI(i), attributes.getQName(i), attributes.getValue(i));
        }
        el.setUserData(LINE_NUMBER_KEY_NAME, String.valueOf(this.locator.getLineNumber()), null);
        this.elementStack.push(el);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.addTextIfNeeded();
        Element closedEl = this.elementStack.pop();
        if (this.elementStack.isEmpty()) {
            this.doc.appendChild(closedEl);
        } else {
            Element parentEl = this.elementStack.peek();
            parentEl.appendChild(closedEl);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.textBuffer.append(ch, start, length);
    }

    private void addTextIfNeeded() {
        if (this.textBuffer.length() > 0) {
            Element el = this.elementStack.peek();
            Text textNode = this.doc.createTextNode(this.textBuffer.toString());
            el.appendChild(textNode);
            this.textBuffer.delete(0, this.textBuffer.length());
        }
    }
}

