/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.json;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.jangaroo.exml.json.Json;
import net.jangaroo.exml.json.JsonArray;
import net.jangaroo.exml.utils.ExmlUtils;
import net.jangaroo.utils.CompilerUtils;

public class JsonObject
implements Json {
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String NET_JANGAROO_EXT_CREATE = "net.jangaroo.ext.create";
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private String wrapperClass;
    private String configClass;

    public JsonObject(Object ... namesAndValues) {
        if (namesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("argument vector must be of even length, but is " + Arrays.asList(namesAndValues));
        }
        for (int i = 0; i < namesAndValues.length; i += 2) {
            Object name = namesAndValues[i];
            if (!(name instanceof String)) {
                throw new IllegalArgumentException("property names must be strings, found '" + name + "'");
            }
            Object value = namesAndValues[i + 1];
            this.properties.put((String)name, value);
        }
    }

    public String getWrapperClass() {
        return this.wrapperClass;
    }

    public JsonObject settingWrapperClass(String wrapperClass) {
        this.wrapperClass = wrapperClass;
        return this;
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indentFactor) {
        return this.toString(indentFactor, 0);
    }

    public static String valueToString(Object value, int indentFactor, int indent) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JsonObject) {
            return ((JsonObject)value).toString(indentFactor, indent);
        }
        if (value instanceof JsonArray) {
            return ((JsonArray)value).toString(indentFactor, indent);
        }
        if (ExmlUtils.isCodeExpression(value.toString())) {
            return ExmlUtils.getCodeExpression(value.toString());
        }
        return CompilerUtils.quote(value.toString());
    }

    @Override
    public String toString(int indentFactor, int indent) {
        Set<String> keySet = this.properties.keySet();
        StringBuilder sb = new StringBuilder();
        if (this.wrapperClass != null) {
            sb.append("new ").append(this.wrapperClass).append('(');
        } else if (this.configClass != null) {
            sb.append(NET_JANGAROO_EXT_CREATE).append('(').append(this.configClass).append(',');
        }
        sb.append("{");
        int newindent = indent + indentFactor;
        int n = keySet.size();
        Iterator<String> keys = keySet.iterator();
        if (n == 1) {
            this.writeKeyValue(keys.next(), indentFactor, indent, sb);
        } else if (n > 1) {
            boolean isFirstAttribute = true;
            while (keys.hasNext()) {
                if (isFirstAttribute) {
                    isFirstAttribute = false;
                } else {
                    sb.append(",");
                }
                this.newlineAndIndent(sb, newindent);
                this.writeKeyValue(keys.next(), indentFactor, newindent, sb);
            }
            if (sb.length() > 1) {
                this.newlineAndIndent(sb, indent);
            }
        }
        sb.append('}');
        if (this.wrapperClass != null || this.configClass != null) {
            sb.append(')');
        }
        return sb.toString();
    }

    private void newlineAndIndent(StringBuilder sb, int indent) {
        sb.append(LINE_SEPARATOR);
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
    }

    private void writeKeyValue(String key, int indentFactor, int indent, StringBuilder sb) {
        sb.append(key);
        sb.append(": ");
        sb.append(JsonObject.valueToString(this.properties.get(key), indentFactor, indent));
    }

    @Override
    public Object get(String property) {
        return this.properties.get(property);
    }

    @Override
    public void set(String property, Object value) {
        this.properties.put(property, value);
    }

    public Object remove(String property) {
        return this.properties.remove(property);
    }

    public void settingConfigClass(String fullName) {
        this.configClass = fullName;
    }
}

