/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jangaroo.exml.json.Json;
import net.jangaroo.exml.json.JsonObject;

public class JsonArray
implements Json {
    private List<Object> items = new ArrayList<Object>();

    public JsonArray(Object ... items) {
        this.items = new ArrayList<Object>(Arrays.asList(items));
    }

    public String toString() {
        return this.items.toString();
    }

    @Override
    public String toString(int indentFactor, int indent) {
        int len = this.items.size();
        if (len == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        if (len == 1) {
            sb.append(JsonObject.valueToString(this.items.get(0), indentFactor, indent));
        } else {
            int i;
            int newindent = indent + indentFactor;
            sb.append(JsonObject.LINE_SEPARATOR);
            for (i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(",").append(JsonObject.LINE_SEPARATOR);
                }
                for (int j = 0; j < newindent; ++j) {
                    sb.append(' ');
                }
                sb.append(JsonObject.valueToString(this.items.get(i), indentFactor, newindent));
            }
            sb.append(JsonObject.LINE_SEPARATOR);
            for (i = 0; i < indent; ++i) {
                sb.append(' ');
            }
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public Object get(String property) {
        return this.items.get(Integer.parseInt(property));
    }

    @Override
    public void set(String property, Object value) {
        this.items.set(Integer.parseInt(property), value);
    }
}

