/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import java.io.Writer;
import net.jangaroo.jooc.SubstitutingWriter;

public class JsStringLiteralWriter
extends SubstitutingWriter {
    protected boolean insideScriptTag;

    public JsStringLiteralWriter(Writer out, boolean insideScriptTag) {
        super(out);
        this.insideScriptTag = insideScriptTag;
    }

    @Override
    protected String substitute(char ch) {
        if (ch == '\"') {
            return "\\\"";
        }
        if (ch == '\n') {
            return "\\n";
        }
        if (ch == '/' && this.insideScriptTag) {
            return "\\/";
        }
        if (ch == '\\') {
            return "\\\\";
        }
        if (ch < '\u0010') {
            return "\\x0" + Integer.toHexString(ch);
        }
        if (ch < ' ') {
            return "\\x" + Integer.toHexString(ch);
        }
        return null;
    }

    public void beginString() throws IOException {
        this.out.write(34);
    }

    public void endString() throws IOException {
        this.out.write(34);
    }
}

