/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.jangaroo.jooc.CompilationResultImpl;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.StdOutCompileLog;
import net.jangaroo.jooc.api.CompilationResult;
import net.jangaroo.jooc.api.CompileLog;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.backend.AbstractCompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.CompilationUnitSink;
import net.jangaroo.jooc.backend.CompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.MergedOutputCompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.SingleFileCompilationUnitSinkFactory;
import net.jangaroo.jooc.cli.CommandLineParseException;
import net.jangaroo.jooc.cli.JoocCommandLineParser;
import net.jangaroo.jooc.config.JoocConfiguration;
import net.jangaroo.jooc.config.JoocOptions;
import net.jangaroo.jooc.config.NamespaceConfiguration;
import net.jangaroo.jooc.config.ParserOptions;
import net.jangaroo.jooc.config.PublicApiViolationsMode;
import net.jangaroo.jooc.input.FileInputSource;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.input.PathInputSource;
import net.jangaroo.jooc.input.ZipEntryInputSource;
import net.jangaroo.jooc.mxml.CatalogComponentsParser;
import net.jangaroo.jooc.mxml.CatalogGenerator;
import net.jangaroo.jooc.mxml.ComponentPackageManifestParser;
import net.jangaroo.jooc.mxml.ComponentPackageModel;
import net.jangaroo.jooc.mxml.MxmlComponentRegistry;
import net.jangaroo.jooc.properties.PropertiesCompiler;
import net.jangaroo.utils.FileLocations;

public class Jooc
extends JangarooParser
implements net.jangaroo.jooc.api.Jooc {
    public static final String PUBLIC_API_EXCLUSION_ANNOTATION_NAME = "ExcludeClass";
    public static final String PUBLIC_API_INCLUSION_ANNOTATION_NAME = "PublicApi";
    public static final String NATIVE_ANNOTATION_NAME = "Native";
    public static final String ACCESSOR_ANNOTATION_NAME = "Accessor";
    public static final String BINDABLE_ANNOTATION_NAME = "Bindable";
    private List<CompilationUnit> compileQueue = new ArrayList<CompilationUnit>();

    public Jooc() {
    }

    public Jooc(JoocConfiguration config) {
        this(config, (CompileLog)new StdOutCompileLog());
    }

    public Jooc(JoocConfiguration config, CompileLog log) {
        super((ParserOptions)config, log);
    }

    public JoocConfiguration getConfig() {
        return (JoocConfiguration)super.getConfig();
    }

    public void setConfig(JoocConfiguration config) {
        super.setConfig((ParserOptions)config);
    }

    public CompilationResult run() {
        try {
            return this.run1();
        }
        catch (CompilerError e) {
            if (e.getSymbol() != null) {
                this.log.error(e.getSymbol(), e.getMessage());
            } else {
                this.log.error(e.getMessage());
            }
            return new CompilationResultImpl(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error(e.getMessage());
            return new CompilationResultImpl(2);
        }
    }

    private CompilationResult run1() {
        PathInputSource classPathInputSource;
        PathInputSource sourcePathInputSource;
        try {
            sourcePathInputSource = PathInputSource.fromFiles(this.getConfig().getSourcePath(), new String[]{""}, true);
            classPathInputSource = PathInputSource.fromFiles(this.getConfig().getClassPath(), new String[]{"", "META-INF/joo-api/"}, false);
        }
        catch (IOException e) {
            throw new CompilerError("IO Exception occurred", e);
        }
        this.setUp(sourcePathInputSource, classPathInputSource);
        PropertiesCompiler propertiesCompiler = new PropertiesCompiler((FileLocations)this.getConfig());
        HashMap<File, File> outputFileMap = new HashMap<File, File>();
        try {
            this.setUpMxmlComponentRegistry(sourcePathInputSource, classPathInputSource);
            for (File sourceFile : this.getConfig().getSourceFiles()) {
                if (sourceFile.getName().endsWith(".properties")) {
                    if (sourceFile.getParentFile() == null || sourceFile.getParentFile().getParentFile() == null || !"locale".equals(sourceFile.getParentFile().getParentFile().getName())) continue;
                    outputFileMap.put(sourceFile, propertiesCompiler.generate(sourceFile));
                    continue;
                }
                this.processSource(sourceFile);
            }
            CompilationUnitSinkFactory codeSinkFactory = this.createSinkFactory(this.getConfig(), false);
            CompilationUnitSinkFactory apiSinkFactory = null;
            if (this.getConfig().isGenerateApi()) {
                apiSinkFactory = this.createSinkFactory(this.getConfig(), true);
            }
            for (CompilationUnit unit : this.compileQueue) {
                unit.analyze(null);
                if (this.getConfig().getPublicApiViolationsMode() != PublicApiViolationsMode.ALLOW) {
                    this.reportPublicApiViolations(unit);
                }
                File sourceFile = ((FileInputSource)unit.getSource()).getFile();
                File outputFile = null;
                if (unit.getAnnotation(NATIVE_ANNOTATION_NAME) == null && !unit.getPrimaryDeclaration().isNative()) {
                    outputFile = this.writeOutput(sourceFile, unit, codeSinkFactory, this.getConfig().isVerbose());
                }
                outputFileMap.put(sourceFile, outputFile);
                if (!this.getConfig().isGenerateApi()) continue;
                this.writeOutput(sourceFile, unit, apiSinkFactory, this.getConfig().isVerbose());
            }
            int result = this.log.hasErrors() ? 1 : 0;
            CompilationResultImpl compilationResultImpl = new CompilationResultImpl(result, outputFileMap);
            return compilationResultImpl;
        }
        catch (IOException e) {
            throw new CompilerError("IO Exception occurred", e);
        }
        finally {
            this.tearDown();
        }
    }

    private void setUpMxmlComponentRegistry(InputSource sourcePathInputSource, InputSource classPathInputSource) throws IOException {
        List<InputSource> children = classPathInputSource.getChildren("catalog.xml");
        CatalogComponentsParser catalogParser = new CatalogComponentsParser(this.getMxmlComponentRegistry());
        for (InputSource child : children) {
            catalogParser.parse(child.getInputStream());
        }
        MxmlComponentRegistry localMxmlComponentRegistry = new MxmlComponentRegistry();
        List namespaces = this.getConfig().getNamespaces();
        for (NamespaceConfiguration namespace : namespaces) {
            InputSource componentPackageManifestInputSource;
            String componentPackageManifest = namespace.getManifest();
            if (componentPackageManifest == null) {
                componentPackageManifest = "manifest.xml";
            }
            if ((componentPackageManifestInputSource = sourcePathInputSource.getChild(componentPackageManifest)) == null) {
                Jooc.warning("manifest file not found in source path: " + componentPackageManifest);
                continue;
            }
            InputStream manifestInputStream = componentPackageManifestInputSource.getInputStream();
            ComponentPackageModel componentPackageModel = new ComponentPackageManifestParser(namespace.getUri()).parse(manifestInputStream);
            this.getMxmlComponentRegistry().add(componentPackageModel);
            localMxmlComponentRegistry.add(componentPackageModel);
        }
        if (!localMxmlComponentRegistry.getComponentPackageModels().isEmpty()) {
            new CatalogGenerator(localMxmlComponentRegistry).generateCatalog(new File(this.getConfig().getApiOutputDirectory(), "catalog.xml"));
        }
    }

    private void reportPublicApiViolations(CompilationUnit unit) {
        for (CompilationUnit compilationUnit : unit.getDependenciesAsCompilationUnits()) {
            if (!(compilationUnit.getSource() instanceof ZipEntryInputSource) || compilationUnit.getAnnotation(PUBLIC_API_EXCLUSION_ANNOTATION_NAME) == null) continue;
            String msg = "PUBLIC API VIOLATION: " + compilationUnit.getPrimaryDeclaration().getQualifiedNameStr();
            File sourceFile = new File(unit.getSymbol().getFileName());
            if (this.getConfig().getPublicApiViolationsMode() == PublicApiViolationsMode.WARN) {
                JangarooParser.warning(msg, sourceFile);
                continue;
            }
            throw JangarooParser.error(msg, sourceFile);
        }
    }

    public File writeOutput(File sourceFile, CompilationUnit compilationUnit, CompilationUnitSinkFactory writerFactory, boolean verbose) throws CompilerError {
        CompilationUnitSink sink = writerFactory.createSink(compilationUnit.getPackageDeclaration(), compilationUnit.getPrimaryDeclaration(), sourceFile, verbose);
        return sink.writeOutput(compilationUnit);
    }

    private CompilationUnitSinkFactory createSinkFactory(JoocConfiguration config, boolean generateActionScriptApi) {
        AbstractCompilationUnitSinkFactory codeSinkFactory;
        if (!generateActionScriptApi && config.isMergeOutput()) {
            codeSinkFactory = new MergedOutputCompilationUnitSinkFactory((JoocOptions)config, config.getOutputFile());
        } else {
            File outputDirectory = generateActionScriptApi ? config.getApiOutputDirectory() : config.getOutputDirectory();
            String suffix = generateActionScriptApi ? ".as" : ".js";
            codeSinkFactory = new SingleFileCompilationUnitSinkFactory((JoocOptions)config, outputDirectory, generateActionScriptApi, suffix);
        }
        return codeSinkFactory;
    }

    public static String getResultCodeDescription(int resultCode) {
        switch (resultCode) {
            case 0: {
                return "ok";
            }
            case 1: {
                return "compilation failed";
            }
            case 2: {
                return "internal compiler error";
            }
            case 3: {
                return "unrecognized option";
            }
            case 4: {
                return "missing option argument";
            }
            case 5: {
                return "illegal option value";
            }
        }
        return "unknown result code";
    }

    protected void processSource(File file) throws IOException {
        if (file.isDirectory()) {
            throw Jooc.error("Input file is a directory.", file);
        }
        CompilationUnit unit = this.importSource(new FileInputSource(this.getConfig().findSourceDir(file), file, true));
        if (unit != null) {
            this.compileQueue.add(unit);
        }
    }

    public static int run(String[] argv, CompileLog log) {
        try {
            JoocCommandLineParser commandLineParser = new JoocCommandLineParser();
            JoocConfiguration config = commandLineParser.parse(argv);
            if (config != null) {
                return new Jooc(config, log).run().getResultCode();
            }
        }
        catch (CommandLineParseException e) {
            System.out.println(e.getMessage());
            return e.getExitCode();
        }
        return 0;
    }

    public static void main(String[] argv) {
        int result = Jooc.run(argv, new StdOutCompileLog());
        if (result != 0) {
            System.exit(result);
        }
    }
}

