// class com.codecatalyst.promise.CancellationError
joo.classLoader.prepare(
"package com.codecatalyst.promise",
"public class CancellationError extends Error",2,function($$private){return[

"public function CancellationError",function(reason)
{
joo.Error.call(this,reason);
},
undefined];},[],[], "0.8.0", "2.0.9"
);
// class com.codecatalyst.promise.CompletionAction
joo.classLoader.prepare(
"package com.codecatalyst.promise",
"internal class CompletionAction",1,function($$private){return[

"public static const",{FULFILL:"fulfill"},
"public static const",{REJECT:"reject"},
undefined];},[],[], "0.8.0", "2.0.9"
);
// class com.codecatalyst.promise.Consequence
joo.classLoader.prepare(
"package com.codecatalyst.promise",
"internal class Consequence",1,function($$private){var is=joo.is,as=joo.as,$$bound=joo.boundMethod,$1=com.codecatalyst.promise,$2=com.codecatalyst.util,$3=flash.utils;return[function(){joo.classLoader.init(com.codecatalyst.promise.CompletionAction);},

"public function get promise",function()
{
return this.resolver$1.promise;
},
"private var",{resolver:null},
"private var",{onFulfilled:null},
"private var",{onRejected:null},
"public function Consequence",function(onFulfilled,onRejected)
{
this.onFulfilled$1=onFulfilled;
this.onRejected$1=onRejected;
this.resolver$1=new $1.Resolver();
},
"public function trigger",function(action,value)
{
switch(action)
{
case $1.CompletionAction.FULFILL:
this.propagate$1(value,this.onFulfilled$1,$$bound(this.resolver$1,"resolve"));
break;
case $1.CompletionAction.REJECT:
this.propagate$1(value,this.onRejected$1,$$bound(this.resolver$1,"reject"));
break;
}
},
"private function propagate",function(value,callback,resolverMethod)
{
if(is(callback,Function))
{
this.schedule$1($$bound(this,"transform$1"),[value,callback]);
}
else
{
resolverMethod.call(this.resolver$1,value);
}
},
"private function transform",function(value,callback)
{
try
{
this.resolver$1.resolve($2.optionally(callback,[value]));
}
catch(error)
{
this.resolver$1.reject(error);
}
},
"private function schedule",function(callback,parameters)
{if(arguments.length<=1)parameters=null;
com.codecatalyst.promise.Consequence.CallbackQueue.instance.schedule(callback,parameters);
},

"class CallbackQueue",1,function($$private){var is=joo.is,as=joo.as,$$bound=joo.boundMethod,$1=com.codecatalyst.promise,$2=com.codecatalyst.util,$3=flash.utils;return[

"public static const",{instance:function(){return(new com.codecatalyst.promise.Consequence.CallbackQueue());}},
"protected const",{queuedCallbacks:function(){return(new Array(1e4));}},
"protected var",{intervalId:0},
"protected var",{queuedCallbackCount:0},
"public function CallbackQueue",function()
{if(0===0){this.queuedCallbacks=this.queuedCallbacks();};
},
"public function schedule",function(callback,parameters)
{if(arguments.length<=1)parameters=null;
this.queuedCallbacks[this.queuedCallbackCount++]=new com.codecatalyst.promise.Consequence.Callback(callback,parameters);
if(this.queuedCallbackCount==1)
{
this.intervalId=$3.setInterval($$bound(this,"execute"),0);
}
},
"protected function execute",function()
{
$3.clearInterval(this.intervalId);
var index=0;
while(index<this.queuedCallbackCount)
{
(as(this.queuedCallbacks[index],com.codecatalyst.promise.Consequence.Callback)).execute();
this.queuedCallbacks[index]=null;
index++;
}
this.queuedCallbackCount=0;
},
undefined];},[],
"class Callback",1,function($$private){var is=joo.is,as=joo.as,$$bound=joo.boundMethod,$1=com.codecatalyst.promise,$2=com.codecatalyst.util,$3=flash.utils;return[

"protected var",{closure:null},
"protected var",{parameters:null},
"public function Callback",function(closure,parameters)
{if(arguments.length<=1)parameters=null;;
this.closure=closure;
this.parameters=parameters;
},
"public function execute",function()
{
this.closure.apply(null,this.parameters);
},
undefined];},[],undefined];},[],["com.codecatalyst.promise.Resolver","com.codecatalyst.promise.CompletionAction","com.codecatalyst.util.optionally","Array","flash.utils.setInterval","flash.utils.clearInterval"], "0.8.0", "2.0.9"
);
// class com.codecatalyst.promise.Deferred
joo.classLoader.prepare(
"package com.codecatalyst.promise",
"public class Deferred",1,function($$private){var $1=com.codecatalyst.promise;return[

"public static function resolve",function(value)
{
var deferred=new $1.Deferred();
deferred.resolve(value);
return deferred.promise;
},
"public static function reject",function(reason)
{
var deferred=new $1.Deferred();
deferred.reject(reason);
return deferred.promise;
},
"public function get promise",function()
{
return this.resolver.promise;
},
"protected var",{resolver:null},
"public function Deferred",function()
{;
this.resolver=new $1.Resolver();
},
"public function resolve",function(value)
{
this.resolver.resolve(value);
},
"public function reject",function(reason)
{
this.resolver.reject(reason);
},
undefined];},["resolve","reject"],["com.codecatalyst.promise.Resolver"], "0.8.0", "2.0.9"
);
// class com.codecatalyst.promise.logger.LogLevel
joo.classLoader.prepare(
"package com.codecatalyst.promise.logger",
"public class LogLevel",1,function($$private){return[

"public static const",{DEBUG:2},
"public static const",{INFO:4},
"public static const",{WARN:6},
"public static const",{ERROR:8},
"public static const",{FATAL:1000},
undefined];},[],[], "0.8.0", "2.0.9"
);
// class com.codecatalyst.promise.logger.TraceLogger
joo.classLoader.prepare(
"package com.codecatalyst.promise.logger",
"public class TraceLogger",1,function($$private){var trace=joo.trace,$1=com.codecatalyst.promise.logger;return[function(){joo.classLoader.init(com.codecatalyst.promise.logger.LogLevel);},

"private static const",{labelsByLevel:function(){return({});}},function(){
{
$$private.labelsByLevel[$1.LogLevel.DEBUG]='DEBUG';
$$private.labelsByLevel[$1.LogLevel.INFO]='INFO';
$$private.labelsByLevel[$1.LogLevel.WARN]='WARN';
$$private.labelsByLevel[$1.LogLevel.ERROR]='ERROR';
$$private.labelsByLevel[$1.LogLevel.FATAL]='FATAL';
}},
"public static function log",function(category,level,message)
{var parameters=Array.prototype.slice.call(arguments,3);
for(var i=0;i<parameters.length;i++)
{
message=message.replace(new RegExp("\\{"+i+"\\}","g"),parameters[i]);
}
trace('['+$$private.labelsByLevel[level]+'] '+category+': '+message);
},
undefined];},["log"],["com.codecatalyst.promise.logger.LogLevel"], "0.8.0", "2.0.9"
);
// class com.codecatalyst.promise.Promise
joo.classLoader.prepare(
"package com.codecatalyst.promise",
"public class Promise",1,function($$private){var as=joo.as,is=joo.is,$$bound=joo.boundMethod,$3=com.codecatalyst.promise,$4=flash.events,$5=flash.utils,$6=com.codecatalyst.util,$7=com.codecatalyst.promise.logger;return[function(){joo.classLoader.init(com.codecatalyst.promise.logger.LogLevel,flash.events.TimerEvent);},

"public static function when",function(value)
{
for(var $1=0;$1<$$private.adapters.length;++$1)
{var adapt=$$private.adapters[$1];var promise=as(adapt(value),$3.Promise);
if(promise)
{
return promise;
}
}var deferred=new $3.Deferred();
deferred.resolve(value);
return deferred.promise;
},
"public static function isThenable",function(value)
{
return(value!=null&&(is(value,Object)||is(value,Function))&&"then"in value&&is(value.then,Function));
},
"public static function all",function(promisesOrValues)
{
if(!(is(promisesOrValues,Array)||$3.Promise.isThenable(promisesOrValues)))
{
throw new Error("Invalid parameter: expected an Array or Promise of an Array.");
}
function process(promisesOrValues)
{
var remainingToResolve=promisesOrValues.length;
var results=new Array(promisesOrValues.length);
var deferred=new $3.Deferred();
if(remainingToResolve>0)
{
function resolve(item,index)
{
function fulfill(value)
{
results[index]=value;
if(--remainingToResolve==0)
{
deferred.resolve(results);
}
return value;
}
return $3.Promise.when(item).then(fulfill,$$bound(deferred,"reject"));
}
for(var index=0;index<promisesOrValues.length;index++)
{
if(index in promisesOrValues)
{
resolve(promisesOrValues[index],index);
}
else
{
remainingToResolve--;
}
}
}
else
{
deferred.resolve(results);
}
return deferred.promise;
}
return $3.Promise.when(promisesOrValues).then(process);
},
"public static function any",function(promisesOrValues)
{
if(!(is(promisesOrValues,Array)||$3.Promise.isThenable(promisesOrValues)))
{
throw new Error("Invalid parameter: expected an Array or Promise of an Array.");
}
function extract(array)
{
return array[0];
}
function transform(reason)
{
if(is(reason,Error)&&reason.message=="Too few Promises were resolved.")
{
throw new Error("No Promises were resolved.");
}
throw reason;
}
return $3.Promise.some(promisesOrValues,1).then(extract,transform);
},
"public static function some",function(promisesOrValues,howMany)
{
if(!(is(promisesOrValues,Array)||$3.Promise.isThenable(promisesOrValues)))
{
throw new Error("Invalid parameter: expected an Array or Promise of an Array.");
}
function process(promisesOrValues)
{
var values=[];
var remainingToResolve=howMany;
var remainingToReject=(promisesOrValues.length-remainingToResolve)+1;
var deferred=new $3.Deferred();
if(promisesOrValues.length<howMany)
{
deferred.reject(new Error("Too few Promises were resolved."));
}
else
{
function onResolve(value)
{
if(remainingToResolve>0){
values.push(value);
}
remainingToResolve--;
if(remainingToResolve==0)
{
deferred.resolve(values);
}
return value;
}
function onReject(reason)
{
remainingToReject--;
if(remainingToReject==0)
{
deferred.reject(new Error("Too few Promises were resolved."));
}
throw reason;
}
for(var index=0;index<promisesOrValues.length;index++)
{
if(index in promisesOrValues)
{
$3.Promise.when(promisesOrValues[index]).then(onResolve,onReject);
}
}
}
return deferred.promise;
}
return $3.Promise.when(promisesOrValues).then(process);
},
"public static function delay",function(promiseOrValue,milliseconds)
{
var deferred=new $3.Deferred();
function timerCompleteHandler()
{
timer.removeEventListener($4.TimerEvent.TIMER_COMPLETE,timerCompleteHandler);
deferred.resolve(promiseOrValue);
}
var timer=new $5.Timer(Math.max(milliseconds,0),1);
timer.addEventListener($4.TimerEvent.TIMER_COMPLETE,timerCompleteHandler);
timer.start();
return deferred.promise;
},
"public static function timeout",function(promiseOrValue,milliseconds)
{
var deferred=new $3.Deferred();
function timerCompleteHandler()
{
timer.removeEventListener($4.TimerEvent.TIMER_COMPLETE,timerCompleteHandler);
deferred.reject(new Error("Promise timed out."));
}
var timer=new $5.Timer(Math.max(milliseconds,0),1);
timer.addEventListener($4.TimerEvent.TIMER_COMPLETE,timerCompleteHandler);
timer.start();
$3.Promise.when(promiseOrValue).then($$bound(deferred,"resolve"),$$bound(deferred,"reject"));
return deferred.promise;
},
"public static function map",function(promisesOrValues,mapFunction)
{
if(!(is(promisesOrValues,Array)||$3.Promise.isThenable(promisesOrValues)))
{
throw new Error("Invalid parameter: expected an Array or Promise of an Array.");
}
if(!(is(mapFunction,Function)))
{
throw new Error("Invalid parameter: expected a function.");
}
function process(promisesOrValues)
{
var remainingToResolve=promisesOrValues.length;
var results=new Array(promisesOrValues.length);
var deferred=new $3.Deferred();
if(remainingToResolve>0)
{
function resolve(item,index)
{
function transform(value)
{
return $6.optionally(mapFunction,[value,index,results]);
}
function fulfill(value)
{
results[index]=value;
if(--remainingToResolve==0)
{
deferred.resolve(results);
}
}
return $3.Promise.when(item).then(transform).then(fulfill,$$bound(deferred,"reject"));
}
for(var index=0;index<promisesOrValues.length;index++)
{
if(index in promisesOrValues)
{
resolve(promisesOrValues[index],index);
}
else
{
remainingToResolve--;
}
}
}
else
{
deferred.resolve(results);
}
return deferred.promise;
}
return $3.Promise.when(promisesOrValues).then(process);
},
"public static function reduce",function(promisesOrValues,reduceFunction)
{var rest=Array.prototype.slice.call(arguments,2);
if(!(is(promisesOrValues,Array)||$3.Promise.isThenable(promisesOrValues)))
{
throw new Error("Invalid parameter: expected an Array or Promise of an Array.");
}
if(!(is(reduceFunction,Function)))
{
throw new Error("Invalid parameter: expected a function.");
}
function reduceArray(array,reduceFunction)
{var rest=Array.prototype.slice.call(arguments,2);
var index=0;
var length=array.length;
var reduced=null;
if(rest.length==0){
for(index=0;index<length;index++)
{
if(index in array)
{
reduced=array[index];
index++;
break;
}
}
}
else
{
reduced=rest[0];
}
while(index<length)
{
if(index in array)
{
reduced=reduceFunction(reduced,array[index],index,array);
index++;
}
}
return reduced;
}
function process(promisesOrValues)
{
function reduceFnWrapper(previousValueOrPromise,currentValueOrPromise,currentIndex,array)
{
function execute(previousValue,currentValue)
{
return $6.optionally(reduceFunction,[previousValue,currentValue,currentIndex,array]);
}
return $3.Promise.all([previousValueOrPromise,currentValueOrPromise]).then($6.spread(execute));
}
if(rest.length>0)
{
var initialValue=rest[0];
return reduceArray(promisesOrValues,reduceFnWrapper,initialValue);
}
else
{
return reduceArray(promisesOrValues,reduceFnWrapper);
}
}
return $3.Promise.when(promisesOrValues).then(process);
},
"public static function log",function(category,level,message)
{var parameters=Array.prototype.slice.call(arguments,3);
var loggerParameters=[category,level,message].concat(parameters);
for(var $2=0;$2<$$private.loggers.length;++$2)
{var logger=$$private.loggers[$2];
logger.apply(logger,loggerParameters);
}
},
"public static function registerAdapter",function(adapter)
{
if($$private.adapters.indexOf(adapter)==-1)
{
$$private.adapters.push(adapter);
}
},
"public static function unregisterAdapter",function(adapter)
{var index=$$private.adapters.indexOf(adapter);
if(index>-1)
{
$$private.adapters.splice(index,1);
}
},
"public static function registerLogger",function(logger)
{
if($$private.loggers.indexOf(logger)==-1)
{
$$private.loggers.push(logger);
}
},
"public static function unregisterLogger",function(logger)
{var index=$$private.loggers.indexOf(logger);
if(index>-1)
{
$$private.loggers.splice(index,1);
}
},
"private static function scheduleRethrowError",function(error)
{
$6.nextTick($$private.rethrowError,[error]);
},
"private static function rethrowError",function(error)
{
if(is(error,Error))
{
throw error.getStackTrace()+"\nRethrown from:";
}
else
{
throw error;
}
},
"private static const",{adapters:function(){return([]);}},
"private static const",{loggers:function(){return([]);}},
"private var",{resolver:null},
"public function Promise",function(resolver)
{
this.resolver$1=resolver;
},
"public function then",function(onFulfilled,onRejected)
{switch(arguments.length){case 0:onFulfilled=null;case 1:onRejected=null;}
return this.resolver$1.then(onFulfilled,onRejected);
},
"public function otherwise",function(onRejected)
{
return this.resolver$1.then(null,onRejected);
},
"public function always",function(onCompleted)
{
function onFulfilled(value)
{
try
{
onCompleted();
}
catch(error){if(is(error,Error))
{
$$private.scheduleRethrowError(error);
}else throw error;}
return value;
}
function onRejected(reason)
{
try
{
onCompleted();
}
catch(error){if(is(error,Error))
{
$$private.scheduleRethrowError(error);
}else throw error;}
throw reason;
}
return this.resolver$1.then(onFulfilled,onRejected);
},
"public function done",function()
{
this.resolver$1.then(null,$$private.scheduleRethrowError);
},
"public function cancel",function(reason)
{
this.resolver$1.reject(new $3.CancellationError(reason));
},
"public function log",function(category,identifier)
{if(arguments.length<=1)identifier=null;
function onFulfilled(value)
{
try
{
$3.Promise.log(category,$7.LogLevel.DEBUG,(identifier||"Promise")+" resolved with value: "+value);
}
catch(error){if(is(error,Error))
{
$$private.scheduleRethrowError(error);
}else throw error;}
return value;
}
function onRejected(reason)
{
try
{
$3.Promise.log(category,$7.LogLevel.ERROR,(identifier||"Promise")+" rejected with reason: "+reason);
}
catch(error){if(is(error,Error))
{
$$private.scheduleRethrowError(error);
}else throw error;}
throw reason;
}
return this.resolver$1.then(onFulfilled,onRejected);
},
undefined];},["when","isThenable","all","any","some","delay","timeout","map","reduce","log","registerAdapter","unregisterAdapter","registerLogger","unregisterLogger"],["com.codecatalyst.promise.Deferred","Array","flash.events.TimerEvent","flash.utils.Timer","com.codecatalyst.util.optionally","com.codecatalyst.util.spread","com.codecatalyst.util.nextTick","com.codecatalyst.promise.CancellationError","com.codecatalyst.promise.logger.LogLevel"], "0.8.0", "2.0.9"
);
// class com.codecatalyst.promise.Resolver
joo.classLoader.prepare(
"package com.codecatalyst.promise",
"internal class Resolver",1,function($$private){var is=joo.is,$2=com.codecatalyst.promise;return[function(){joo.classLoader.init(com.codecatalyst.promise.CompletionAction);},

"public function get promise",function()
{
return this._promise$1;
},
"private var",{_promise:null},
{ArrayElementType:{$value:"com.codecatalyst.promise.Consequence"}},
"private var",{consequences:function(){return([]);}},
"private var",{completed:false},
"private var",{completionAction:null},
"private var",{completionValue:undefined},
"public function Resolver",function()
{if(0===0){this.consequences$1=this.consequences$1();}
this._promise$1=new $2.Promise(this);
this.consequences$1=[];
},
"public function then",function(onFulfilled,onRejected)
{switch(arguments.length){case 0:onFulfilled=null;case 1:onRejected=null;}
var consequence=new $2.Consequence(onFulfilled,onRejected);
if(this.completed$1)
{
consequence.trigger(this.completionAction$1,this.completionValue$1);
}
else
{
this.consequences$1.push(consequence);
}
return consequence.promise;
},
"public function resolve",function(value)
{
if(this.completed$1)
{
return;
}
try
{
if(value==this.promise)
{
throw new TypeError("A Promise cannot be resolved with itself.");
}
var thenFunction;
if(value!=null&&(is(value,Object)||is(value,Function))&&"then"in value&&is((thenFunction=value.then),Function))
{
var isHandled=false;
var self=this;
try
{
thenFunction.call(
value,
function(value)
{
if(!isHandled)
{
isHandled=true;
self.resolve(value);
}
},
function(reason)
{
if(!isHandled)
{
isHandled=true;
self.reject(reason);
}
}
);
}
catch(error)
{
if(!isHandled)
{
this.reject(error);
}
}
}
else
{
this.complete$1($2.CompletionAction.FULFILL,value);
}
}
catch(error)
{
this.reject(error);
}
},
"public function reject",function(reason)
{
if(this.completed$1)
{
return;
}
this.complete$1($2.CompletionAction.REJECT,reason);
},
"private function complete",function(action,value)
{
this.completionAction$1=action;
this.completionValue$1=value;
this.completed$1=true;
for(var $1=0;$1<this.consequences$1.length;++$1)
{var consequence=this.consequences$1[$1];
consequence.trigger(this.completionAction$1,this.completionValue$1);
}
this.consequences$1=[];
},
undefined];},[],["com.codecatalyst.promise.Promise","com.codecatalyst.promise.Consequence","com.codecatalyst.promise.CompletionAction"], "0.8.0", "2.0.9"
);
// class com.codecatalyst.util.nextTick
joo.classLoader.prepare(
"package com.codecatalyst.util",
"public function nextTick",0,function(){var $1=flash.utils;return function(callback,parameters)
{if(arguments.length<=1)parameters=null;
function execute(){
$1.clearInterval(intervalId);
callback.apply(null,parameters);
}
var intervalId=$1.setInterval(execute,0);
}
;},[],["flash.utils.clearInterval","flash.utils.setInterval"], "0.8.0", "2.0.9"
);
// class com.codecatalyst.util.optionally
joo.classLoader.prepare(
"package com.codecatalyst.util",
"public function optionally",0,function(){var is=joo.is;return function(targetFunction,parameters,requiredParameters)
{if(arguments.length<=2)requiredParameters=0;
try{
return targetFunction.apply(null,parameters);
}catch(e){if(is(e,ArgumentError)){
var parameterCount=Math.max(targetFunction.length,requiredParameters);
if(parameterCount<parameters.length){
return targetFunction.apply(null,parameters.slice(0,parameterCount));
}
throw e;
}else throw e;}
}
;},[],["ArgumentError"], "0.8.0", "2.0.9"
);
// class com.codecatalyst.util.spread
joo.classLoader.prepare(
"package com.codecatalyst.util",
"public function spread",0,function(){return function(targetFunction,scope)
{if(arguments.length<=1)scope=null;
function execute(array){
return targetFunction.apply(scope,array);
}
return execute;
}
;},[],[], "0.8.0", "2.0.9"
);
