joo.classLoader.prepare(////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2013 CodeCatalyst, LLC - http://www.codecatalyst.com/
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.	
////////////////////////////////////////////////////////////////////////////////

"package com.codecatalyst.util",/*
{*/
	/**
	 * Creates a new wrapper function that spreads the passed Array over the 
	 * target function arguments.
	 * 
	 * @param targetFunction Function to wrap.
	 * @param scope Optional scope in which to execute the wrapped function.
	 * @return The new wrapper function.
	 */
	"public function spread",0,function(){return function spread( targetFunction/*:Function*/, scope/*:* = null*/ )/*:Function*/
	{if(arguments.length<=1)scope=null;
		function execute( array/*:Array*/ )/*:**/ {
			return targetFunction.apply( scope, array );
		}
		
		return execute;
	}
;},[],[], "0.8.0", "2.0.9"
);