joo.classLoader.prepare(////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2013 CodeCatalyst, LLC - http://www.codecatalyst.com/
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.	
////////////////////////////////////////////////////////////////////////////////

"package com.codecatalyst.promise",/*
{
	import com.codecatalyst.util.optionally;
	import flash.utils.clearInterval;
	import flash.utils.setInterval;*/

	/**
	 * Consequences are used internally by a Resolver to capture and notify 
	 * callbacks, and propagate their transformed results as fulfillment or 
	 * rejection.
	 * 
	 * Developers never directly interact with a Consequence.
	 * 
	 * A Consequence forms a chain between two Resolvers, where the result of 
	 * the first Resolver is transformed by the corresponding callback before 
	 * being applied to the second Resolver.
	 * 
	 * Each time a Resolver's then() method is called, it creates a new 
	 * Consequence that will be triggered once its originating Resolver has 
	 * been fulfilled or rejected. A Consequence captures a pair of optional 
	 * onFulfilled and onRejected callbacks.
	 * 
	 * Each Consequence has its own Resolver (which in turn has a Promise) 
	 * that is resolved or rejected when the Consequence is triggered. When a 
	 * Consequence is triggered by its originating Resolver, it calls the 
	 * corresponding callback and propagates the transformed result to its own 
	 * Resolver; resolved with the callback return value or rejected with any 
	 * error thrown by the callback.
	 */
	"internal class Consequence",1,function($$private){var is=joo.is,as=joo.as,$$bound=joo.boundMethod,$1=com.codecatalyst.promise,$2=com.codecatalyst.util,$3=flash.utils;return[function(){joo.classLoader.init(com.codecatalyst.promise.CompletionAction);},
	
		// ========================================
		// Public properties
		// ========================================
		
		/**
		 * Promise of the future value of this Consequence.
		 */
		"public function get promise",function promise$get()/*:Promise*/
		{
			return this.resolver$1.promise;
		},
		
		// ========================================
		// Private properties
		// ========================================
		
		/**
		 * Internal Resolver for this Consequence.
		 */
		"private var",{ resolver/*:Resolver*/ : null},
		
		/**
		 * Callback to execute when this Consequence is triggered with a fulfillment value.
		 */
		"private var",{ onFulfilled/*:Function*/ : null},
		
		/**
		 * Callback to execute when this Consequence is triggered with a rejection reason.
		 */
		"private var",{ onRejected/*:Function*/ : null},
				
		// ========================================
		// Constructor
		// ========================================
		
		/**
		 * Constructor.
		 * 
		 * @param onFulfilled Callback to execute to transform a fulfillment value.
		 * @param onRejected Callback to execute to transform a rejection reason.
		 */
		"public function Consequence",function Consequence( onFulfilled/*:Function*/, onRejected/*:Function*/ )
		{
			this.onFulfilled$1 = onFulfilled;
			this.onRejected$1 = onRejected;
			
			this.resolver$1 = new $1.Resolver();
		},
		
		// ========================================
		// Public methods
		// ========================================
		
		/**
		 * Trigger this Consequence with the specified action and value.
		 * 
		 * @param action Completion action (i.e. CompletionAction.FULFILL or CompletionAction.REJECT).
		 * @param value Fulfillment value or rejection reason.
		 */
		"public function trigger",function trigger( action/*:String*/, value/*:**/ )/*:void*/
		{
			switch ( action )
			{
				case $1.CompletionAction.FULFILL:
					this.propagate$1( value, this.onFulfilled$1,$$bound( this.resolver$1,"resolve") );
					break;
				
				case $1.CompletionAction.REJECT:
					this.propagate$1( value, this.onRejected$1,$$bound( this.resolver$1,"reject") );
					break;
			}
		},
		
		// ========================================
		// Private methods
		// ========================================
		
		/**
		 * Propagate the specified value using either the optional callback or
		 * a Resolver method.
		 * 
		 * @param value Value to transform and/or propagate.
		 * @param callback (Optional) callback to use to transform the value. 
		 * @param resolverMethod Resolver method to call to propagate the value, if no callback was specified.
		 */
		"private function propagate",function propagate( value/*:**/, callback/*:Function*/, resolverMethod/*:Function*/ )/*:void*/
		{
			if (is( callback,  Function) )
			{
				this.schedule$1( $$bound(this,"transform$1"), [ value, callback ] );
			}
			else
			{
				resolverMethod.call( this.resolver$1, value );
			}
		},
		
		/**
		 * Transform the specified value using the specified callback and 
		 * propagate the transformed result.
		 * 
		 * @param value Value to transform.
		 * @param callback Callback to execute to transform the value.
		 */
		"private function transform",function transform( value/*:**/, callback/*:Function*/ )/*:void*/
		{
			try
			{
				this.resolver$1.resolve( $2.optionally( callback, [ value ] ) );
			}
			catch ( error/*:**/ ) 
			{
				this.resolver$1.reject( error );
			}
		},
		
		/**
		 * Schedules the specified callback function to be executed on
		 * the next turn of the event loop.
		 * 
		 * @param callback Callback function.
		 * @param parameters Optional parameters to pass to the callback function.
		 */
		"private function schedule",function schedule( callback/*:Function*/, parameters/*:Array = null*/ )/*:void*/
		{if(arguments.length<=1)parameters=null;
			com.codecatalyst.promise.Consequence.CallbackQueue.instance.schedule( callback, parameters );
		},
	

/**
 * Used to queue callbacks for execution on the next turn of the event loop (using a single Array instance and timer).
 * 
 * @private
 */
"class CallbackQueue",1,function($$private){var is=joo.is,as=joo.as,$$bound=joo.boundMethod,$1=com.codecatalyst.promise,$2=com.codecatalyst.util,$3=flash.utils;return[

	// ========================================
	// Public properties
	// ========================================
	
	/**
	 * Singleton instance accessor.
	 */
	"public static const",{ instance/*:CallbackQueue*/ :function(){return( new com.codecatalyst.promise.Consequence.CallbackQueue());}},
	
	// ========================================
	// Protected properties
	// ========================================
	
	/**
	 * Queued Callback(s).
	 */
	"protected const",{ queuedCallbacks/*:Array*/ :function(){return( new Array(1e4));}},
	
	/**
	 * Interval identifier.
	 */
	"protected var",{ intervalId/*:int*/ : 0},
	
	/**
	 * # of pending callbacks.
	 */
	"protected var",{ queuedCallbackCount/*:uint*/ : 0},
	
	// ========================================
	// Constructor
	// ========================================
	
	"public function CallbackQueue",function CallbackQueue()
	{/*
		super()*/if(0===0){this.queuedCallbacks=this.queuedCallbacks();};
	},
	
	// ========================================
	// Public methods
	// ========================================
	
	/**
	 * Add a callback to the end of the queue, to be executed on the next turn of the event loop.
	 * 
	 * @param callback Callback function.
	 * @param parameters Optional parameters to pass to the callback function.
	 */
	"public function schedule",function schedule( callback/*:Function*/, parameters/*:Array = null*/ )/*:void*/
	{if(arguments.length<=1)parameters=null;
		this.queuedCallbacks[ this.queuedCallbackCount++ ] = new com.codecatalyst.promise.Consequence.Callback( callback, parameters );
		
		if ( this.queuedCallbackCount == 1 )
		{
			this.intervalId = $3.setInterval( $$bound(this,"execute"), 0 );
		}
	},
	
	// ========================================
	// Protected methods
	// ========================================
	
	/**
	 * Execute any queued callbacks and clear the queue.
	 */
	"protected function execute",function execute()/*:void*/
	{
		$3.clearInterval( this.intervalId );
		
		var index/*:uint*/ = 0;
		while ( index < this.queuedCallbackCount )
		{
			(as(this.queuedCallbacks[ index ],  com.codecatalyst.promise.Consequence.Callback)).execute();
			this.queuedCallbacks[ index ] = null;
			index++;
		}
		
		this.queuedCallbackCount = 0;
	},
undefined];},[],

/**
 * Used to capture a callback closure, along with optional parameters.
 * 
 * @private
 */
"class Callback",1,function($$private){var is=joo.is,as=joo.as,$$bound=joo.boundMethod,$1=com.codecatalyst.promise,$2=com.codecatalyst.util,$3=flash.utils;return[

	// ========================================
	// Protected properties
	// ========================================
	
	/**
	 * Callback closure.
	 */
	"protected var",{ closure/*:Function*/:null},
	
	/**
	 * Callback parameters.
	 */
	"protected var",{ parameters/*:Array*/:null},
	
	// ========================================
	// Constructor
	// ========================================
	
	"public function Callback",function Callback( closure/*:Function*/, parameters/*:Array = null*/ )
	{if(arguments.length<=1)parameters=null;/*
		super()*/;
		
		this.closure = closure;
		this.parameters = parameters;
	},
	
	// ========================================
	// Public methods
	// ========================================
	
	/**
	 * Execute this callback.
	 */
	"public function execute",function execute()/*:void*/
	{
		this.closure.apply( null, this.parameters );
	},
undefined];},[],undefined];},[],["com.codecatalyst.promise.Resolver","com.codecatalyst.promise.CompletionAction","com.codecatalyst.util.optionally","Array","flash.utils.setInterval","flash.utils.clearInterval"], "0.8.0", "2.0.9"
);