package com.codecatalyst.promise.logger {

/**
 * TraceLogger is a custom logger function that logs messages via trace().
	 * 
	 * To register this logger:
	 * <code>Promise.registerLogger(TraceLogger.log)</code>
	 *
	 * To unregister this logger:
	 * <code>Promise.unregisterLogger(TraceLogger.log)</code>
 */
public class TraceLogger {
  /**
   * Logs a message with the specified category, log level and 
		 * optional parameters.
		 * 
		 * @param category Category
		 * @param level Log level
		 * @param message Message
		 * @param parameters Optional message parameters
   */
  public static native function log(category:String, level:int, message:String, ...parameters):void;
}
}