package com.codecatalyst.promise {

/**
 * A Deferred is typically used within the body of a function that performs
	 * an asynchronous operation. When that operation succeeds, the Deferred 
	 * should be resolved; if that operation fails, the Deferred should be rejected.
	 * 
	 * Deferreds are the mechanism used to create new Promises. A Deferred has a 
	 * single associated Promise that can be safely returned to external consumers 
	 * to ensure they do not interfere with the resolution or rejection of the 
	 * deferred operation.
 */
public class Deferred {
  /**
   * Convenience method that returns a new Promise resolved with the specified value.
		 *
 		 * @param value Value to resolve as either a fulfillment value or rejection reason.
		 * @return Resolved Promise.
   */
  public static native function resolve(value:*):Promise;

  /**
   * Convenience method that returns a new Promise rejected with the specified reason.
		 * 
		 * @param reason Rejection reason.
		 * @return Rejected Promise.
   */
  public static native function reject(reason:*):Promise;

  /**
   * Promise of the future value of this Deferred.
   */
  public native function get promise():Promise;

  /**
   * Internal Resolver for this Deferred.
   */
  protected var resolver:Resolver;

  public function Deferred() {
    super();
  }

  /**
   * Resolve this Deferred with the specified value.
		 * 
		 * Once a Deferred has been fulfilled or rejected, it is considered to be complete 
		 * and subsequent calls to resolve() or reject() are ignored.
		 * 
		 * @param value Value to resolve as either a fulfillment value or rejection reason.
   */
  public native function resolve(value:*):void;

  /**
   * Reject this Deferred with the specified error.
		 * 
		 * Once a Deferred has been rejected, it is considered to be complete
		 * and subsequent calls to resolve() or reject() are ignored.
		 * 
		 * @param reason Rejection reason.
   */
  public native function reject(reason:*):void;
}
}