package com.codecatalyst.promise {

/**
 * Consequences are used internally by a Resolver to capture and notify 
	 * callbacks, and propagate their transformed results as fulfillment or 
	 * rejection.
	 * 
	 * Developers never directly interact with a Consequence.
	 * 
	 * A Consequence forms a chain between two Resolvers, where the result of 
	 * the first Resolver is transformed by the corresponding callback before 
	 * being applied to the second Resolver.
	 * 
	 * Each time a Resolver's then() method is called, it creates a new 
	 * Consequence that will be triggered once its originating Resolver has 
	 * been fulfilled or rejected. A Consequence captures a pair of optional 
	 * onFulfilled and onRejected callbacks.
	 * 
	 * Each Consequence has its own Resolver (which in turn has a Promise) 
	 * that is resolved or rejected when the Consequence is triggered. When a 
	 * Consequence is triggered by its originating Resolver, it calls the 
	 * corresponding callback and propagates the transformed result to its own 
	 * Resolver; resolved with the callback return value or rejected with any 
	 * error thrown by the callback.
 */
public class Consequence {
  /**
   * Promise of the future value of this Consequence.
   */
  public native function get promise():Promise;

  /**
   * Constructor.
		 * 
		 * @param onFulfilled Callback to execute to transform a fulfillment value.
		 * @param onRejected Callback to execute to transform a rejection reason.
   */
  public function Consequence(onFulfilled:Function, onRejected:Function) {
    super();
  }

  /**
   * Trigger this Consequence with the specified action and value.
		 * 
		 * @param action Completion action (i.e. CompletionAction.FULFILL or CompletionAction.REJECT).
		 * @param value Fulfillment value or rejection reason.
   */
  public native function trigger(action:String, value:*):void;
}
}