/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.servlet;

import com.alibaba.dubbo.remoting.http.HttpHandler;
import com.alibaba.dubbo.remoting.http.servlet.AsyncThread;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(name="dubboServlet", urlPatterns={"/service/*"}, asyncSupported=true)
public class DispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = 5766349180380479888L;
    private static DispatcherServlet INSTANCE;
    private static final Map<Integer, HttpHandler> handlers;

    public static void addHttpHandler(int port, HttpHandler processor) {
        handlers.put(port, processor);
    }

    public static void removeHttpHandler(int port) {
        handlers.remove(port);
    }

    public static DispatcherServlet getInstance() {
        return INSTANCE;
    }

    public DispatcherServlet() {
        INSTANCE = this;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpHandler handler = handlers.get(request.getLocalPort());
        request.setAttribute("org.apache.catalina.ASYNC_SUPPORTED", (Object)true);
        AsyncContext asyncCtx = request.startAsync();
        asyncCtx.setTimeout(-1L);
        AsyncThread asyncThread = new AsyncThread();
        asyncThread.setRequest(request);
        asyncThread.setResponse(response);
        asyncThread.setHandler(handler);
        asyncThread.setAsyncCtx(asyncCtx);
        ExecutorService executor = (ExecutorService)request.getServletContext().getAttribute("executor");
        executor.execute(asyncThread);
    }

    static {
        handlers = new ConcurrentHashMap<Integer, HttpHandler>();
    }
}

