/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.rest.filter;

import com.alibaba.dubbo.rpc.RpcContext;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import net.jahhan.common.extension.constant.BaseConfiguration;
import net.jahhan.common.extension.utils.StringUtils;
import net.jahhan.context.BaseContext;
import net.jahhan.context.BaseVariable;
import net.jahhan.context.VariableContext;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@Priority(value=-2147483647)
public class RpcContextFilter
implements ContainerRequestFilter,
ClientRequestFilter,
ContainerResponseFilter {
    private static final String DUBBO_ATTACHMENT_HEADER = "Attachment";
    private static final int MAX_HEADER_SIZE = 8192;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        BaseContext applicationContext = BaseContext.CTX;
        VariableContext variableContext = new VariableContext();
        applicationContext.getThreadLocalUtil().openThreadLocal(variableContext);
        BaseVariable base = BaseVariable.getBaseVariable();
        HttpServletRequest request = (HttpServletRequest)ResteasyProviderFactory.getContextData(HttpServletRequest.class);
        RpcContext.getContext().setRequest(request);
        if (request != null && RpcContext.getContext().getRemoteAddress() == null) {
            RpcContext.getContext().setRemoteAddress(request.getRemoteAddr(), request.getRemotePort());
        }
        RpcContext.getContext().setResponse(ResteasyProviderFactory.getContextData(HttpServletResponse.class));
        String headers = requestContext.getHeaderString(DUBBO_ATTACHMENT_HEADER);
        if (headers != null) {
            for (String header : headers.split(",")) {
                int index = header.indexOf("=");
                if (index <= 0) continue;
                String key = header.substring(0, index);
                String value = header.substring(index + 1);
                if (StringUtils.isEmpty(key)) continue;
                String string = URLDecoder.decode(value.trim(), "UTF-8");
                RpcContext.getContext().setAttachment(key.trim(), string);
            }
        }
        Map<String, String> attachments = RpcContext.getContext().getAttachments();
        String requestId = attachments.get("request_id");
        String chainId = attachments.get("chain_id");
        String behaviorId = attachments.get("behavior_id");
        if (null == requestId) {
            requestId = UUID.randomUUID().toString();
        }
        if (null == chainId) {
            chainId = UUID.randomUUID().toString();
        }
        if (null == behaviorId) {
            behaviorId = UUID.randomUUID().toString();
        }
        base.setRequestId(requestId);
        base.setChainId(chainId);
        base.setBehaviorId(behaviorId);
        BaseContext.CTX.setChain(chainId, Thread.currentThread());
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        int size = 0;
        for (Map.Entry<String, String> entry : RpcContext.getContext().getAttachments().entrySet()) {
            if (entry.getValue().contains(",") || entry.getValue().contains("=") || entry.getKey().contains(",") || entry.getKey().contains("=")) {
                throw new IllegalArgumentException("The attachments of " + RpcContext.class.getSimpleName() + " must not contain ',' or '=' when using rest protocol");
            }
            if ((size += entry.getValue().getBytes("UTF-8").length) > 8192) {
                throw new IllegalArgumentException("The attachments of " + RpcContext.class.getSimpleName() + " is too big");
            }
            StringBuilder attachments = new StringBuilder();
            attachments.append(entry.getKey());
            attachments.append("=");
            String encode = URLEncoder.encode(entry.getValue(), "UTF-8");
            attachments.append(encode);
            requestContext.getHeaders().add((Object)DUBBO_ATTACHMENT_HEADER, (Object)attachments.toString());
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        MultivaluedMap headers = responseContext.getHeaders();
        if (BaseConfiguration.IS_DEBUG) {
            headers.add((Object)"Access-Control-Allow-Origin", (Object)"*");
            headers.add((Object)"Access-Control-Allow-Headers", (Object)"x-requested-with, ssi-token");
            headers.add((Object)"Access-Control-Max-Age", (Object)"3600");
            headers.add((Object)"Access-Control-Allow-Methods", (Object)"GET,POST,PUT,DELETE,OPTIONS");
        }
        int size = 0;
        for (Map.Entry<String, String> entry : RpcContext.getContext().getAttachments().entrySet()) {
            if (entry.getValue().contains(",") || entry.getValue().contains("=") || entry.getKey().contains(",") || entry.getKey().contains("=")) {
                throw new IllegalArgumentException("The attachments of " + RpcContext.class.getSimpleName() + " must not contain ',' or '=' when using rest protocol");
            }
            if ((size += entry.getValue().getBytes("UTF-8").length) > 8192) {
                throw new IllegalArgumentException("The attachments of " + RpcContext.class.getSimpleName() + " is too big");
            }
            StringBuilder attachments = new StringBuilder();
            attachments.append(entry.getKey());
            attachments.append("=");
            String encode = URLEncoder.encode(entry.getValue(), "UTF-8");
            attachments.append(encode);
            responseContext.getHeaders().add((Object)DUBBO_ATTACHMENT_HEADER, (Object)attachments.toString());
        }
    }
}

