/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.init.module;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.jahhan.api.Wrapper;
import net.jahhan.com.alibaba.dubbo.common.compiler.Compiler;
import net.jahhan.com.alibaba.dubbo.common.compiler.support.JavassistCompiler;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.common.extension.annotation.SPI;
import net.jahhan.common.extension.utils.ClassScaner;
import net.jahhan.common.extension.utils.ExtensionUtil;
import net.jahhan.common.extension.utils.LogUtil;
import net.jahhan.common.extension.utils.PackageUtil;
import net.jahhan.common.extension.utils.PropertiesUtil;
import net.jahhan.init.InitAnnocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.guice.annotation.EnableGuiceModules;

@InitAnnocation(isLazy=false, initSequence=4500)
@EnableGuiceModules
public class ExtensionInitModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(ExtensionInitModule.class);
    private Map<Class<?>, Set<Class<?>>> cachedWrapperClasses = new HashMap();
    private Compiler compiler = new JavassistCompiler();
    public static boolean needRun = true;

    protected void configure() {
        if (needRun) {
            Class<?> interfaceClass;
            Class<?> clazz;
            String[] packages = PackageUtil.packages("extension");
            List<String> classNameList = new ClassScaner().parse(packages);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Properties properties = PropertiesUtil.getProperties("extensionInit");
            HashMap unSetMap = new HashMap();
            ArrayList settedList = new ArrayList();
            for (String className : classNameList) {
                try {
                    clazz = classLoader.loadClass(className);
                    interfaceClass = ExtensionInitModule.getSuperInterfaceByAnnotation(clazz, SPI.class);
                    if (null == interfaceClass || !Wrapper.class.isAssignableFrom(clazz)) continue;
                    Set<Class<?>> wrappers = this.cachedWrapperClasses.get(interfaceClass);
                    if (wrappers == null) {
                        wrappers = new HashSet();
                        this.cachedWrapperClasses.put(interfaceClass, wrappers);
                    }
                    wrappers.add(clazz);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            for (String className : classNameList) {
                try {
                    Class<?> createExtension;
                    clazz = classLoader.loadClass(className);
                    interfaceClass = ExtensionInitModule.getSuperInterfaceByAnnotation(clazz, SPI.class);
                    if (null == interfaceClass || !clazz.isAnnotationPresent(Extension.class)) continue;
                    Extension extension = clazz.getAnnotation(Extension.class);
                    String extensionValue = extension.value();
                    Set<Class<?>> set = this.cachedWrapperClasses.get(interfaceClass);
                    if (null != set && set.contains(clazz)) continue;
                    String defaultPlugin = properties.getProperty(interfaceClass.getName());
                    if (extensionValue.equals(defaultPlugin)) {
                        createExtension = this.createExtension(interfaceClass, clazz);
                        if (null != set && set.size() > 0) {
                            if (log.isDebugEnabled()) {
                                log.debug("bind " + interfaceClass.getName() + " to " + createExtension.getName());
                                log.debug("bind " + interfaceClass.getName() + " named " + extensionValue + " to " + createExtension.getName());
                            }
                            this.bind(interfaceClass).toInstance(createExtension);
                            this.bind(interfaceClass).annotatedWith((Annotation)Names.named((String)extensionValue)).toInstance(createExtension);
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug("bind " + interfaceClass.getName() + " to " + createExtension.getName());
                                log.debug("bind " + interfaceClass.getName() + " named " + extensionValue + " to " + createExtension.getName());
                            }
                            this.bind(interfaceClass).to(createExtension).in(Scopes.SINGLETON);
                            this.bind(interfaceClass).annotatedWith((Annotation)Names.named((String)extensionValue)).to(createExtension).in(Scopes.SINGLETON);
                        }
                        settedList.add(interfaceClass);
                        continue;
                    }
                    createExtension = this.createExtension(interfaceClass, clazz);
                    if (null != set && set.size() > 0) {
                        if (log.isDebugEnabled()) {
                            log.debug("bind " + interfaceClass.getName() + " to " + createExtension.getName());
                        }
                        this.bind(interfaceClass).to(createExtension).in(Scopes.SINGLETON);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("bind " + interfaceClass.getName() + " named " + extensionValue + " to " + createExtension.getName());
                        }
                        this.bind(interfaceClass).annotatedWith((Annotation)Names.named((String)extensionValue)).to(createExtension).in(Scopes.SINGLETON);
                    }
                    ArrayList list = (ArrayList)unSetMap.get(interfaceClass);
                    if (null == list) {
                        list = new ArrayList();
                        list.add(clazz);
                        unSetMap.put(interfaceClass, list);
                        continue;
                    }
                    list.add(clazz);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            for (Class next : unSetMap.keySet()) {
                if (settedList.contains(next)) continue;
                Class<?> createExtension = this.createExtension(next, (Class)((List)unSetMap.get(next)).get(0));
                if (log.isDebugEnabled()) {
                    log.debug("bind " + next.getName() + " to" + createExtension.getName());
                }
                this.bind(next).to(createExtension).in(Scopes.SINGLETON);
            }
        }
    }

    private <T> Class<?> createExtension(Class<T> intefaceClass, Class<? extends T> defaultClass) {
        block7: {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Map<Class<?>, Map<Class<?>, String>> extensionCacheClassNameMap = ExtensionUtil.getExtensionCacheClassNameMap();
            try {
                Set<Class<?>> set = this.cachedWrapperClasses.get(intefaceClass);
                if (null != set && set.size() > 0) {
                    Map<Class<?>, String> map = extensionCacheClassNameMap.get(intefaceClass);
                    String nextExtName = map.get(defaultClass);
                    Class<Object> compile = defaultClass;
                    for (Class<?> wrapperClass : set) {
                        String extName = map.get(wrapperClass);
                        extName = extName + "$wrapper$" + nextExtName;
                        String createWrapperExtensionClassCode = this.createWrapperExtensionClassCode(intefaceClass, extName, nextExtName);
                        compile = this.compiler.compile(createWrapperExtensionClassCode, classLoader);
                        if (log.isDebugEnabled()) {
                            log.debug("bind " + intefaceClass + " named $" + extName + " to " + wrapperClass.getName());
                        }
                        this.bind(intefaceClass).annotatedWith((Annotation)Names.named((String)("$" + extName))).to(wrapperClass).in(Scopes.SINGLETON);
                        nextExtName = extName;
                        if (log.isDebugEnabled()) {
                            log.debug("bind " + intefaceClass + " named wrapper$" + nextExtName + " to " + compile.getName());
                        }
                        this.bind(intefaceClass).annotatedWith((Annotation)Names.named((String)("wrapper$" + nextExtName))).to(compile).in(Scopes.SINGLETON);
                    }
                    if (null != compile) {
                        this.bind(intefaceClass).annotatedWith((Annotation)Names.named((String)("$" + map.get(defaultClass)))).to(defaultClass).in(Scopes.SINGLETON);
                        return compile;
                    }
                    break block7;
                }
                return defaultClass;
            }
            catch (Exception e) {
                LogUtil.error(e.getMessage(), e);
            }
        }
        return defaultClass;
    }

    private String createWrapperExtensionClassCode(Class<?> type, String extName, String nextExtName) {
        StringBuilder codeBuidler = new StringBuilder();
        Method[] methods = type.getMethods();
        codeBuidler.append("// dubbo extension code:");
        codeBuidler.append(type.getName());
        codeBuidler.append("\npackage " + type.getPackage().getName() + ";");
        codeBuidler.append("\nimport " + ExtensionUtil.class.getName() + ";");
        codeBuidler.append("\nimport javax.inject.Singleton;");
        codeBuidler.append("\n");
        codeBuidler.append("\n@Singleton");
        codeBuidler.append("\npublic class " + type.getSimpleName() + "$Wrapper$" + extName + " implements " + type.getCanonicalName() + " {");
        codeBuidler.append("\nprivate " + type.getName() + " extension = null;");
        codeBuidler.append("\nprivate final String extName = \"" + extName + "\";");
        codeBuidler.append("\npublic " + type.getSimpleName() + "$Wrapper$" + extName + "(){");
        StringBuilder code = new StringBuilder(512);
        code.append("\nString extensionName=extName;");
        code.append(String.format("\n extension = (%s)%s.getExtensionDirect(%s.class,extName);", type.getName(), ExtensionUtil.class.getSimpleName(), type.getName()));
        code.append("\nif(extName.contains(\"wrapper\\$\")){");
        code.append("\n" + Wrapper.class.getName() + " wrapper = (" + Wrapper.class.getName() + ") extension;");
        code.append("\nextensionName = extName.substring(extName.indexOf(\"wrapper\\$\")+8);");
        code.append("\nwrapper.setExtName(extensionName);");
        code.append(String.format("\nwrapper.setIntefaceClass(%s.class);", type.getName()));
        code.append("\nwrapper.initExtension();");
        code.append("\n}");
        code.append("\n}");
        codeBuidler.append((CharSequence)code);
        codeBuidler.append("\n}");
        for (Method method : methods) {
            int i;
            Class<?> rt = method.getReturnType();
            Class<?>[] pts = method.getParameterTypes();
            Class<?>[] ets = method.getExceptionTypes();
            StringBuilder code2 = new StringBuilder(512);
            if (!rt.equals(Void.TYPE)) {
                code2.append("\nreturn ");
            }
            String s = String.format("extension.%s(", method.getName());
            code2.append(s);
            for (i = 0; i < pts.length; ++i) {
                if (i != 0) {
                    code2.append(", ");
                }
                code2.append("arg").append(i);
            }
            code2.append(");");
            codeBuidler.append("\npublic " + rt.getCanonicalName() + " " + method.getName() + "(");
            for (i = 0; i < pts.length; ++i) {
                if (i > 0) {
                    codeBuidler.append(", ");
                }
                codeBuidler.append(pts[i].getCanonicalName());
                codeBuidler.append(" ");
                codeBuidler.append("arg" + i);
            }
            codeBuidler.append(")");
            if (ets.length > 0) {
                codeBuidler.append(" throws ");
                for (i = 0; i < ets.length; ++i) {
                    if (i > 0) {
                        codeBuidler.append(", ");
                    }
                    codeBuidler.append(ets[0].getName());
                }
            }
            codeBuidler.append(" {");
            codeBuidler.append(code2.toString());
            codeBuidler.append("\n}");
        }
        codeBuidler.append("\n}");
        log.debug(codeBuidler.toString());
        return codeBuidler.toString();
    }

    public static Class<?> getSuperInterfaceByAnnotation(Class<?> type, Class<? extends Annotation> annotation) {
        ArrayList superClasses = new ArrayList();
        superClasses.add(type);
        Class<?> superclass = type;
        while ((superclass = superclass.getSuperclass()) != null) {
            superClasses.add(superclass);
        }
        for (Class clazz : superClasses) {
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces.length <= 0) continue;
            for (Class<?> interfaceClass : interfaces) {
                if (!interfaceClass.isAnnotationPresent(annotation)) continue;
                return interfaceClass;
            }
        }
        return null;
    }
}

