/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.init.module;

import com.alibaba.dubbo.common.URL;
import com.frameworkx.annotation.Activate;
import com.frameworkx.annotation.Adaptive;
import com.frameworkx.common.extension.utils.ExtensionExtendUtil;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.jahhan.api.Wrapper;
import net.jahhan.com.alibaba.dubbo.common.compiler.Compiler;
import net.jahhan.com.alibaba.dubbo.common.compiler.support.JavassistCompiler;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.common.extension.annotation.SPI;
import net.jahhan.common.extension.utils.ClassScaner;
import net.jahhan.common.extension.utils.ExtensionUtil;
import net.jahhan.common.extension.utils.LogUtil;
import net.jahhan.common.extension.utils.PackageUtil;
import net.jahhan.common.extension.utils.PropertiesUtil;
import net.jahhan.init.InitAnnocation;
import net.jahhan.init.module.ExtensionInitModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InitAnnocation(isLazy=false, initSequence=4400)
public class ExtensionExtensionInitModule
extends ExtensionInitModule {
    private static final Logger log = LoggerFactory.getLogger(ExtensionExtensionInitModule.class);
    private Map<Class<?>, Set<Class<?>>> cachedWrapperClasses = new HashMap();
    private Compiler compiler = new JavassistCompiler();

    @Override
    protected void configure() {
        String extensionValue;
        Extension extension;
        ExtensionInitModule.needRun = false;
        String[] packages = PackageUtil.packages("extension");
        List<String> classNameList = new ClassScaner().parse(packages);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Properties properties = PropertiesUtil.getProperties("extensionInit");
        HashMap unSetMap = new HashMap();
        HashMap spiDefaultExtensionMap = new HashMap();
        HashSet adaptiveClassSet = new HashSet();
        HashSet adaptivedClassSet = new HashSet();
        ArrayList settedList = new ArrayList();
        for (String string : classNameList) {
            try {
                Class<?> clazz = classLoader.loadClass(string);
                Class<?> interfaceClass = ExtensionExtensionInitModule.getSuperInterfaceByAnnotation(clazz, SPI.class);
                if (null == interfaceClass || !Wrapper.class.isAssignableFrom(clazz)) continue;
                Set<Class<?>> wrappers = this.cachedWrapperClasses.get(interfaceClass);
                if (wrappers == null) {
                    wrappers = new HashSet();
                    this.cachedWrapperClasses.put(interfaceClass, wrappers);
                }
                wrappers.add(clazz);
            }
            catch (Exception exception) {
                log.error(exception.getMessage(), (Throwable)exception);
            }
        }
        Map<Class<?>, Map<Class<?>, String>> extensionCacheClassNameMap = ExtensionExtendUtil.getExtensionCacheClassNameMap();
        for (String string : classNameList) {
            try {
                Class<?> clazz = classLoader.loadClass(string);
                Class<?> interfaceClass = ExtensionExtensionInitModule.getSuperInterfaceByAnnotation(clazz, SPI.class);
                if (null == interfaceClass) continue;
                SPI interfaceSPI = interfaceClass.getAnnotation(SPI.class);
                if (clazz.isAnnotationPresent(Extension.class)) {
                    Set<Class<?>> set;
                    extension = clazz.getAnnotation(Extension.class);
                    extensionValue = extension.value();
                    Map<Class<?>, String> map = extensionCacheClassNameMap.get(interfaceClass);
                    if (null == map) {
                        map = new ConcurrentHashMap();
                        extensionCacheClassNameMap.put(interfaceClass, map);
                    }
                    map.put(clazz, extensionValue);
                    String defaultPlugin = properties.getProperty(interfaceClass.getName());
                    if (null == defaultPlugin) {
                        defaultPlugin = interfaceSPI.value();
                    }
                    if (extensionValue.equals(defaultPlugin)) {
                        spiDefaultExtensionMap.put(interfaceClass, defaultPlugin);
                    }
                    if (null != (set = this.cachedWrapperClasses.get(interfaceClass)) && set.contains(clazz)) continue;
                    Method[] interfaceMethods = interfaceClass.getMethods();
                    boolean hasAdaptive = false;
                    for (Method m : interfaceMethods) {
                        if (!m.isAnnotationPresent(Adaptive.class)) continue;
                        hasAdaptive = true;
                        break;
                    }
                    if (hasAdaptive) {
                        adaptiveClassSet.add(interfaceClass);
                    }
                }
                if (!clazz.isAnnotationPresent(Adaptive.class)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("bind " + interfaceClass.getName() + " named Adaptive to " + clazz.getName());
                }
                this.bind(interfaceClass).annotatedWith(Adaptive.class).to(clazz).in(Scopes.SINGLETON);
                adaptivedClassSet.add(interfaceClass);
            }
            catch (Exception e) {
                LogUtil.error(e.getMessage(), e);
            }
        }
        for (Class clazz : adaptiveClassSet) {
            if (adaptivedClassSet.contains(clazz)) continue;
            String cachedDefaultName = (String)spiDefaultExtensionMap.get(clazz);
            String createAdaptiveExtensionClassCode = this.createAdaptiveExtensionClassCode(clazz, cachedDefaultName);
            Class<?> compile = this.compiler.compile(createAdaptiveExtensionClassCode, classLoader);
            if (log.isDebugEnabled()) {
                log.debug("bind " + clazz.getName() + " named Adaptive to " + compile.getName());
            }
            this.bind(clazz).annotatedWith(Adaptive.class).to(compile).in(Scopes.SINGLETON);
        }
        Map<Class<?>, Map<String, Activate>> map = ExtensionExtendUtil.getCachedActivates();
        for (String className : classNameList) {
            try {
                Class<?> createExtension;
                Activate activate;
                Class<?> clazz = classLoader.loadClass(className);
                Class<?> interfaceClass = ExtensionExtensionInitModule.getSuperInterfaceByAnnotation(clazz, SPI.class);
                if (null == interfaceClass || !clazz.isAnnotationPresent(Extension.class)) continue;
                extension = clazz.getAnnotation(Extension.class);
                extensionValue = extension.value();
                Set<Class<?>> set = this.cachedWrapperClasses.get(interfaceClass);
                if (null != set && set.contains(clazz)) continue;
                Map<String, Activate> cachedActivates = map.get(interfaceClass);
                if (null == cachedActivates) {
                    cachedActivates = new ConcurrentHashMap<String, Activate>();
                    map.put(interfaceClass, cachedActivates);
                }
                if ((activate = clazz.getAnnotation(Activate.class)) != null) {
                    cachedActivates.put(extensionValue, activate);
                }
                String defaultPlugin = properties.getProperty(interfaceClass.getName());
                Method[] interfaceMethods = interfaceClass.getMethods();
                boolean hasAdaptive = false;
                for (Method m : interfaceMethods) {
                    if (!m.isAnnotationPresent(Adaptive.class)) continue;
                    hasAdaptive = true;
                    break;
                }
                if (hasAdaptive) {
                    adaptiveClassSet.add(interfaceClass);
                    ArrayList list = (ArrayList)unSetMap.get(interfaceClass);
                    if (null == list) {
                        list = new ArrayList();
                        list.add(clazz);
                        unSetMap.put(interfaceClass, list);
                    } else {
                        list.add(clazz);
                    }
                    Class<?> createExtension2 = this.createExtension(interfaceClass, clazz);
                    if (log.isTraceEnabled()) {
                        log.debug("bind " + interfaceClass.getName() + " named " + extensionValue + " to " + createExtension2.getName());
                    }
                    this.bind(interfaceClass).annotatedWith((Annotation)Names.named((String)extensionValue)).to(createExtension2).in(Scopes.SINGLETON);
                    continue;
                }
                if (extensionValue.equals(defaultPlugin)) {
                    createExtension = this.createExtension(interfaceClass, clazz);
                    if (null != set && set.size() > 0) {
                        if (log.isDebugEnabled()) {
                            log.debug("bind " + interfaceClass.getName() + " to " + createExtension.getName());
                            log.debug("bind " + interfaceClass.getName() + " named " + extensionValue + " to " + createExtension.getName());
                        }
                        this.bind(interfaceClass).toInstance(createExtension);
                        this.bind(interfaceClass).annotatedWith((Annotation)Names.named((String)extensionValue)).toInstance(createExtension);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("bind " + interfaceClass.getName() + " to " + createExtension.getName());
                            log.debug("bind " + interfaceClass.getName() + " named " + extensionValue + " to " + createExtension.getName());
                        }
                        this.bind(interfaceClass).to(createExtension).in(Scopes.SINGLETON);
                        this.bind(interfaceClass).annotatedWith((Annotation)Names.named((String)extensionValue)).to(createExtension).in(Scopes.SINGLETON);
                    }
                    settedList.add(interfaceClass);
                    continue;
                }
                createExtension = this.createExtension(interfaceClass, clazz);
                if (null != set && set.size() > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("bind " + interfaceClass.getName() + " to " + createExtension.getName());
                    }
                    this.bind(interfaceClass).to(createExtension).in(Scopes.SINGLETON);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("bind " + interfaceClass.getName() + " named " + extensionValue + " to " + createExtension.getName());
                    }
                    this.bind(interfaceClass).annotatedWith((Annotation)Names.named((String)extensionValue)).to(createExtension).in(Scopes.SINGLETON);
                }
                ArrayList list = (ArrayList)unSetMap.get(interfaceClass);
                if (null == list) {
                    list = new ArrayList();
                    list.add(clazz);
                    unSetMap.put(interfaceClass, list);
                    continue;
                }
                list.add(clazz);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        for (Class next : unSetMap.keySet()) {
            if (settedList.contains(next)) continue;
            Class<?> createExtension = this.createExtension(next, (Class)((List)unSetMap.get(next)).get(0));
            if (log.isDebugEnabled()) {
                log.debug("bind " + next.getName() + " to" + createExtension.getName());
            }
            this.bind(next).to(createExtension).in(Scopes.SINGLETON);
        }
    }

    private <T> Class<?> createExtension(Class<T> intefaceClass, Class<? extends T> defaultClass) {
        block7: {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Map<Class<?>, Map<Class<?>, String>> extensionCacheClassNameMap = ExtensionExtendUtil.getExtensionCacheClassNameMap();
            try {
                Set<Class<?>> set = this.cachedWrapperClasses.get(intefaceClass);
                if (null != set && set.size() > 0) {
                    Map<Class<?>, String> map = extensionCacheClassNameMap.get(intefaceClass);
                    String nextExtName = map.get(defaultClass);
                    Class<Object> compile = defaultClass;
                    for (Class<?> wrapperClass : set) {
                        String extName = map.get(wrapperClass);
                        extName = extName + "$wrapper$" + nextExtName;
                        String createWrapperExtensionClassCode = this.createWrapperExtensionClassCode(intefaceClass, extName, nextExtName);
                        compile = this.compiler.compile(createWrapperExtensionClassCode, classLoader);
                        if (log.isDebugEnabled()) {
                            log.debug("bind " + intefaceClass + " named $" + extName + " to " + wrapperClass.getName());
                        }
                        this.bind(intefaceClass).annotatedWith((Annotation)Names.named((String)("$" + extName))).to(wrapperClass).in(Scopes.SINGLETON);
                        nextExtName = extName;
                        if (log.isDebugEnabled()) {
                            log.debug("bind " + intefaceClass + " named wrapper$" + nextExtName + " to " + compile.getName());
                        }
                        this.bind(intefaceClass).annotatedWith((Annotation)Names.named((String)("wrapper$" + nextExtName))).to(compile).in(Scopes.SINGLETON);
                    }
                    if (null != compile) {
                        this.bind(intefaceClass).annotatedWith((Annotation)Names.named((String)("$" + map.get(defaultClass)))).to(defaultClass).in(Scopes.SINGLETON);
                        return compile;
                    }
                    break block7;
                }
                return defaultClass;
            }
            catch (Exception e) {
                LogUtil.error(e.getMessage(), e);
            }
        }
        return defaultClass;
    }

    private String createAdaptiveExtensionClassCode(Class<?> type, String cachedDefaultName) {
        StringBuilder codeBuidler = new StringBuilder();
        Method[] methods = type.getMethods();
        codeBuidler.append("// dubbo extension code:");
        codeBuidler.append(type.getName());
        codeBuidler.append("\npackage " + type.getPackage().getName() + ";");
        codeBuidler.append("\nimport " + ExtensionUtil.class.getName() + ";");
        codeBuidler.append("\npublic class " + type.getSimpleName() + "$Adpative" + " implements " + type.getCanonicalName() + " {");
        for (Method method : methods) {
            int i;
            Class<?> rt = method.getReturnType();
            Class<?>[] pts = method.getParameterTypes();
            Class<?>[] ets = method.getExceptionTypes();
            Adaptive adaptiveAnnotation = method.getAnnotation(Adaptive.class);
            StringBuilder code = new StringBuilder(512);
            if (adaptiveAnnotation == null) {
                code.append("throw new UnsupportedOperationException(\"method ").append(method.toString()).append(" of interface ").append(type.getName()).append(" is not adaptive method!\");");
            } else {
                int urlTypeIndex = -1;
                for (int i2 = 0; i2 < pts.length; ++i2) {
                    if (!pts[i2].equals(URL.class)) continue;
                    urlTypeIndex = i2;
                    break;
                }
                if (urlTypeIndex != -1) {
                    String s = String.format("\nif (arg%d == null) throw new IllegalArgumentException(\"url == null\");", urlTypeIndex);
                    code.append(s);
                    s = String.format("\n%s url = arg%d;", URL.class.getName(), urlTypeIndex);
                    code.append(s);
                } else {
                    String attribMethod = null;
                    block2: for (int i3 = 0; i3 < pts.length; ++i3) {
                        Method[] ms;
                        for (Method m : ms = pts[i3].getMethods()) {
                            String name = m.getName();
                            if (!name.startsWith("get") && name.length() <= 3 || !Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers()) || m.getParameterTypes().length != 0 || m.getReturnType() != URL.class) continue;
                            urlTypeIndex = i3;
                            attribMethod = name;
                            break block2;
                        }
                    }
                    if (attribMethod == null) {
                        throw new IllegalStateException("fail to create adative class for interface " + type.getName() + ": not found url parameter or url attribute in parameters of method " + method.getName());
                    }
                    String s = String.format("\nif (arg%d == null) throw new IllegalArgumentException(\"%s argument == null\");", urlTypeIndex, pts[urlTypeIndex].getName());
                    code.append(s);
                    s = String.format("\nif (arg%d.%s() == null) throw new IllegalArgumentException(\"%s argument %s() == null\");", urlTypeIndex, attribMethod, pts[urlTypeIndex].getName(), attribMethod);
                    code.append(s);
                    s = String.format("%s url = arg%d.%s();", URL.class.getName(), urlTypeIndex, attribMethod);
                    code.append(s);
                }
                Object[] value = adaptiveAnnotation.value();
                if (value.length == 0) {
                    char[] charArray = type.getSimpleName().toCharArray();
                    StringBuilder sb = new StringBuilder(128);
                    for (int i4 = 0; i4 < charArray.length; ++i4) {
                        if (Character.isUpperCase(charArray[i4])) {
                            if (i4 != 0) {
                                sb.append(".");
                            }
                            sb.append(Character.toLowerCase(charArray[i4]));
                            continue;
                        }
                        sb.append(charArray[i4]);
                    }
                    value = new String[]{sb.toString()};
                }
                boolean hasInvocation = false;
                for (int i5 = 0; i5 < pts.length; ++i5) {
                    if (!pts[i5].getName().equals("com.alibaba.dubbo.rpc.Invocation")) continue;
                    String s = String.format("\nif (arg%d == null) throw new IllegalArgumentException(\"invocation == null\");", i5);
                    code.append(s);
                    s = String.format("\nString methodName = arg%d.getMethodName();", i5);
                    code.append(s);
                    hasInvocation = true;
                    break;
                }
                String defaultExtName = cachedDefaultName;
                String getNameCode = null;
                for (int i6 = value.length - 1; i6 >= 0; --i6) {
                    if (i6 == value.length - 1) {
                        if (null != defaultExtName) {
                            if (!"protocol".equals(value[i6])) {
                                if (hasInvocation) {
                                    getNameCode = String.format("url.getMethodParameter(methodName, \"%s\", \"%s\")", value[i6], defaultExtName);
                                    continue;
                                }
                                getNameCode = String.format("url.getParameter(\"%s\", \"%s\")", value[i6], defaultExtName);
                                continue;
                            }
                            getNameCode = String.format("( url.getProtocol() == null ? \"%s\" : url.getProtocol() )", defaultExtName);
                            continue;
                        }
                        if (!"protocol".equals(value[i6])) {
                            if (hasInvocation) {
                                getNameCode = String.format("url.getMethodParameter(methodName, \"%s\", \"%s\")", value[i6], defaultExtName);
                                continue;
                            }
                            getNameCode = String.format("url.getParameter(\"%s\")", value[i6]);
                            continue;
                        }
                        getNameCode = "url.getProtocol()";
                        continue;
                    }
                    if (!"protocol".equals(value[i6])) {
                        if (hasInvocation) {
                            getNameCode = String.format("url.getMethodParameter(methodName, \"%s\", \"%s\")", value[i6], defaultExtName);
                            continue;
                        }
                        getNameCode = String.format("url.getParameter(\"%s\", %s)", value[i6], getNameCode);
                        continue;
                    }
                    getNameCode = String.format("url.getProtocol() == null ? (%s) : url.getProtocol()", getNameCode);
                }
                code.append("\nString extName = ").append(getNameCode).append(";");
                String s = String.format("\nif(extName == null) throw new IllegalStateException(\"Fail to get extension(%s) name from url(\" + url.toString() + \") use keys(%s)\");", type.getName(), Arrays.toString(value));
                code.append(s);
                s = String.format("\n%s extension = (%<s)%s.getExtension(%s.class,extName);", type.getName(), ExtensionUtil.class.getSimpleName(), type.getName());
                code.append(s);
                if (!rt.equals(Void.TYPE)) {
                    code.append("\nreturn ");
                }
                s = String.format("extension.%s(", method.getName());
                code.append(s);
                for (int i7 = 0; i7 < pts.length; ++i7) {
                    if (i7 != 0) {
                        code.append(", ");
                    }
                    code.append("arg").append(i7);
                }
                code.append(");");
            }
            codeBuidler.append("\npublic " + rt.getCanonicalName() + " " + method.getName() + "(");
            for (i = 0; i < pts.length; ++i) {
                if (i > 0) {
                    codeBuidler.append(", ");
                }
                codeBuidler.append(pts[i].getCanonicalName());
                codeBuidler.append(" ");
                codeBuidler.append("arg" + i);
            }
            codeBuidler.append(")");
            if (ets.length > 0) {
                codeBuidler.append(" throws ");
                for (i = 0; i < ets.length; ++i) {
                    if (i > 0) {
                        codeBuidler.append(", ");
                    }
                    codeBuidler.append(ets[i].getCanonicalName());
                }
            }
            codeBuidler.append(" {");
            codeBuidler.append(code.toString());
            codeBuidler.append("\n}");
        }
        codeBuidler.append("\n}");
        log.debug(codeBuidler.toString());
        return codeBuidler.toString();
    }

    private String createWrapperExtensionClassCode(Class<?> type, String extName, String nextExtName) {
        StringBuilder codeBuidler = new StringBuilder();
        Method[] methods = type.getMethods();
        codeBuidler.append("// dubbo extension code:");
        codeBuidler.append(type.getName());
        codeBuidler.append("\npackage " + type.getPackage().getName() + ";");
        codeBuidler.append("\nimport " + ExtensionUtil.class.getName() + ";");
        codeBuidler.append("\nimport javax.inject.Singleton;");
        codeBuidler.append("\n");
        codeBuidler.append("\n@Singleton");
        codeBuidler.append("\npublic class " + type.getSimpleName() + "$Wrapper$" + extName + " implements " + type.getCanonicalName() + " {");
        codeBuidler.append("\nprivate " + type.getName() + " extension = null;");
        codeBuidler.append("\nprivate final String extName = \"" + extName + "\";");
        codeBuidler.append("\npublic " + type.getSimpleName() + "$Wrapper$" + extName + "(){");
        StringBuilder code = new StringBuilder(512);
        code.append("\nString extensionName=extName;");
        code.append(String.format("\n extension = (%s)%s.getExtensionDirect(%s.class,extName);", type.getName(), ExtensionUtil.class.getSimpleName(), type.getName()));
        code.append("\nif(extName.contains(\"wrapper\\$\")){");
        code.append("\n" + Wrapper.class.getName() + " wrapper = (" + Wrapper.class.getName() + ") extension;");
        code.append("\nextensionName = extName.substring(extName.indexOf(\"wrapper\\$\")+8);");
        code.append("\nwrapper.setExtName(extensionName);");
        code.append(String.format("\nwrapper.setIntefaceClass(%s.class);", type.getName()));
        code.append("\nwrapper.initExtension();");
        code.append("\n}");
        code.append("\n}");
        codeBuidler.append((CharSequence)code);
        codeBuidler.append("\n}");
        for (Method method : methods) {
            int i;
            Class<?> rt = method.getReturnType();
            Class<?>[] pts = method.getParameterTypes();
            Class<?>[] ets = method.getExceptionTypes();
            StringBuilder code2 = new StringBuilder(512);
            if (!rt.equals(Void.TYPE)) {
                code2.append("\nreturn ");
            }
            String s = String.format("extension.%s(", method.getName());
            code2.append(s);
            for (i = 0; i < pts.length; ++i) {
                if (i != 0) {
                    code2.append(", ");
                }
                code2.append("arg").append(i);
            }
            code2.append(");");
            codeBuidler.append("\npublic " + rt.getCanonicalName() + " " + method.getName() + "(");
            for (i = 0; i < pts.length; ++i) {
                if (i > 0) {
                    codeBuidler.append(", ");
                }
                codeBuidler.append(pts[i].getCanonicalName());
                codeBuidler.append(" ");
                codeBuidler.append("arg" + i);
            }
            codeBuidler.append(")");
            if (ets.length > 0) {
                codeBuidler.append(" throws ");
                for (i = 0; i < ets.length; ++i) {
                    if (i > 0) {
                        codeBuidler.append(", ");
                    }
                    codeBuidler.append(ets[0].getName());
                }
            }
            codeBuidler.append(" {");
            codeBuidler.append(code2.toString());
            codeBuidler.append("\n}");
        }
        codeBuidler.append("\n}");
        log.debug(codeBuidler.toString());
        return codeBuidler.toString();
    }
}

