/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.telnetHandler;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.telnet.support.Help;
import com.alibaba.dubbo.remoting.telnet.support.TelnetUtils;
import com.frameworkx.annotation.Activate;
import com.frameworkx.common.extension.utils.ExtensionExtendUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Singleton;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.extension.statusChecker.Status;
import net.jahhan.extension.statusChecker.StatusUtils;
import net.jahhan.spi.StatusChecker;
import net.jahhan.spi.TelnetHandler;

@Activate
@Help(parameter="[-l]", summary="Show status.", detail="Show status.")
@Extension(value="status")
@Singleton
public class StatusTelnetHandler
implements TelnetHandler {
    @Override
    public String telnet(Channel channel, String message) {
        if (message.equals("-l")) {
            List<StatusChecker> checkers = ExtensionExtendUtil.getActivateExtension(StatusChecker.class, channel.getUrl(), "status");
            String[] header = new String[]{"resource", "status", "message"};
            ArrayList<List<String>> table = new ArrayList<List<String>>();
            HashMap<String, Status> statuses = new HashMap<String, Status>();
            if (checkers != null && checkers.size() > 0) {
                for (StatusChecker checker : checkers) {
                    Status stat;
                    String name = ExtensionExtendUtil.getExtensionName(StatusChecker.class, checker.getClass());
                    try {
                        stat = checker.check();
                    }
                    catch (Throwable t) {
                        stat = new Status(Status.Level.ERROR, t.getMessage());
                    }
                    statuses.put(name, stat);
                    if (stat.getLevel() == null || stat.getLevel() == Status.Level.UNKNOWN) continue;
                    ArrayList<String> row = new ArrayList<String>();
                    row.add(name);
                    row.add(String.valueOf((Object)stat.getLevel()));
                    row.add(stat.getMessage() == null ? "" : stat.getMessage());
                    table.add(row);
                }
            }
            Status stat = StatusUtils.getSummaryStatus(statuses);
            ArrayList<String> row = new ArrayList<String>();
            row.add("summary");
            row.add(String.valueOf((Object)stat.getLevel()));
            row.add(stat.getMessage());
            table.add(row);
            return TelnetUtils.toTable(header, table);
        }
        if (message.length() > 0) {
            return "Unsupported parameter " + message + " for status.";
        }
        String status = channel.getUrl().getParameter("status");
        HashMap<String, Status> statuses = new HashMap<String, Status>();
        if (status != null && status.length() > 0) {
            String[] ss;
            for (String s : ss = Constants.COMMA_SPLIT_PATTERN.split(status)) {
                Status stat;
                StatusChecker handler = ExtensionExtendUtil.getExtension(StatusChecker.class, s);
                try {
                    stat = handler.check();
                }
                catch (Throwable t) {
                    stat = new Status(Status.Level.ERROR, t.getMessage());
                }
                statuses.put(s, stat);
            }
        }
        Status stat = StatusUtils.getSummaryStatus(statuses);
        return String.valueOf((Object)stat.getLevel());
    }
}

