/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.statusChecker;

import com.alibaba.dubbo.remoting.exchange.ExchangeServer;
import com.frameworkx.annotation.Activate;
import java.util.Collection;
import javax.inject.Singleton;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.extension.protocol.DubboProtocol;
import net.jahhan.extension.statusChecker.Status;
import net.jahhan.spi.StatusChecker;

@Activate
@Extension(value="server")
@Singleton
public class ServerStatusChecker
implements StatusChecker {
    @Override
    public Status check() {
        Collection<ExchangeServer> servers = DubboProtocol.getDubboProtocol().getServers();
        if (servers == null || servers.size() == 0) {
            return new Status(Status.Level.UNKNOWN);
        }
        Status.Level level = Status.Level.OK;
        StringBuilder buf = new StringBuilder();
        for (ExchangeServer server : servers) {
            if (!server.isBound()) {
                level = Status.Level.ERROR;
                buf.setLength(0);
                buf.append(server.getLocalAddress());
                break;
            }
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(server.getLocalAddress());
            buf.append("(clients:");
            buf.append(server.getChannels().size());
            buf.append(")");
        }
        return new Status(level, buf.toString());
    }
}

