/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.statusChecker;

import com.frameworkx.annotation.Activate;
import javax.inject.Singleton;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.extension.statusChecker.Status;
import net.jahhan.spi.StatusChecker;

@Activate
@Extension(value="memory")
@Singleton
public class MemoryStatusChecker
implements StatusChecker {
    @Override
    public Status check() {
        Runtime runtime = Runtime.getRuntime();
        long freeMemory = runtime.freeMemory();
        long totalMemory = runtime.totalMemory();
        long maxMemory = runtime.maxMemory();
        boolean ok = maxMemory - (totalMemory - freeMemory) > 2048L;
        String msg = "max:" + maxMemory / 1024L / 1024L + "M,total:" + totalMemory / 1024L / 1024L + "M,used:" + (totalMemory / 1024L / 1024L - freeMemory / 1024L / 1024L) + "M,free:" + freeMemory / 1024L / 1024L + "M";
        return new Status(ok ? Status.Level.OK : Status.Level.WARN, msg);
    }
}

