/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.statusChecker;

import com.frameworkx.annotation.Activate;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import javax.inject.Singleton;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.extension.statusChecker.Status;
import net.jahhan.spi.StatusChecker;

@Activate
@Extension(value="load")
@Singleton
public class LoadStatusChecker
implements StatusChecker {
    @Override
    public Status check() {
        double load;
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            Method method = OperatingSystemMXBean.class.getMethod("getSystemLoadAverage", new Class[0]);
            load = (Double)method.invoke((Object)operatingSystemMXBean, new Object[0]);
        }
        catch (Throwable e) {
            load = -1.0;
        }
        int cpu = operatingSystemMXBean.getAvailableProcessors();
        return new Status(load < 0.0 ? Status.Level.UNKNOWN : (load < (double)cpu ? Status.Level.OK : Status.Level.WARN), (load < 0.0 ? "" : "load:" + load + ",") + "cpu:" + cpu);
    }
}

