/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.proxyFactory;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.Version;
import com.alibaba.dubbo.common.utils.ConfigUtils;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.rpc.Exporter;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.service.GenericService;
import com.frameworkx.annotation.Adaptive;
import java.lang.reflect.Constructor;
import javax.inject.Inject;
import net.jahhan.com.alibaba.dubbo.common.bytecode.Wrapper;
import net.jahhan.com.alibaba.dubbo.common.utils.ReflectUtils;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.common.extension.utils.StringUtils;
import net.jahhan.exception.JahhanException;
import net.jahhan.spi.Protocol;
import net.jahhan.spi.ProxyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension(value="stub")
public class StubProxyFactoryWrapper
extends net.jahhan.api.Wrapper<ProxyFactory>
implements ProxyFactory {
    private static final Logger log = LoggerFactory.getLogger(StubProxyFactoryWrapper.class);
    @Inject
    @Adaptive
    private Protocol protocol;

    @Override
    public <T> T getProxy(Invoker<T> invoker) throws JahhanException {
        String stub;
        Object proxy = ((ProxyFactory)this.wrapper).getProxy(invoker);
        if (GenericService.class != invoker.getInterface() && ConfigUtils.isNotEmpty(stub = invoker.getUrl().getParameter("stub", invoker.getUrl().getParameter("local")))) {
            Class<T> serviceType = invoker.getInterface();
            if (ConfigUtils.isDefault(stub)) {
                stub = invoker.getUrl().hasParameter("stub") ? serviceType.getName() + "Stub" : serviceType.getName() + "Local";
            }
            try {
                Class<?> stubClass = ReflectUtils.forName(stub);
                if (!serviceType.isAssignableFrom(stubClass)) {
                    throw new IllegalStateException("The stub implemention class " + stubClass.getName() + " not implement interface " + serviceType.getName());
                }
                try {
                    Constructor<?> constructor = ReflectUtils.findConstructor(stubClass, serviceType);
                    proxy = constructor.newInstance(proxy);
                    URL url = invoker.getUrl();
                    if (url.getParameter("dubbo.stub.event", false)) {
                        url = url.addParameter("dubbo.stub.event.methods", StringUtils.join(Wrapper.getWrapper(proxy.getClass()).getDeclaredMethodNames(), ","));
                        url = url.addParameter("isserver", Boolean.FALSE.toString());
                        try {
                            this.export(proxy, invoker.getInterface(), url);
                        }
                        catch (Exception e) {
                            log.error("export a stub service error.", (Throwable)e);
                        }
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("No such constructor \"public " + stubClass.getSimpleName() + "(" + serviceType.getName() + ")\" in stub implemention class " + stubClass.getName(), e);
                }
            }
            catch (Throwable t) {
                log.error("Failed to create stub implemention class " + stub + " in consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion() + ", cause: " + t.getMessage(), t);
            }
        }
        return (T)proxy;
    }

    @Override
    public <T> Invoker<T> getInvoker(T proxy, Class<T> type, URL url) throws JahhanException {
        return ((ProxyFactory)this.wrapper).getInvoker(proxy, type, url);
    }

    private <T> Exporter<T> export(T instance, Class<T> type, URL url) {
        return this.protocol.export(((ProxyFactory)this.wrapper).getInvoker(instance, type, url));
    }
}

