/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.protocol;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.rpc.Exporter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcResult;
import com.alibaba.dubbo.rpc.protocol.AbstractInvoker;
import com.alibaba.dubbo.rpc.protocol.AbstractProtocol;
import com.frameworkx.common.extension.utils.ExtensionExtendUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.inject.Singleton;
import net.jahhan.com.alibaba.dubbo.common.serialize.ObjectInput;
import net.jahhan.com.alibaba.dubbo.common.serialize.ObjectOutput;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.exception.JahhanException;
import net.jahhan.spi.Serialization;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;

@Extension(value="redis")
@Singleton
public class RedisProtocol
extends AbstractProtocol {
    private static final Logger log = LoggerFactory.getLogger(RedisProtocol.class);
    public static final int DEFAULT_PORT = 6379;

    @Override
    public int getDefaultPort() {
        return 6379;
    }

    @Override
    public <T> Exporter<T> export(Invoker<T> invoker) throws JahhanException {
        throw new UnsupportedOperationException("Unsupported export redis service. url: " + invoker.getUrl());
    }

    private Serialization getSerialization(URL url) {
        return ExtensionExtendUtil.getExtension(Serialization.class, url.getParameter("serialization", "java"));
    }

    @Override
    public <T> Invoker<T> refer(final Class<T> type, final URL url) throws JahhanException {
        try {
            JedisPoolConfig config = new JedisPoolConfig();
            config.setTestOnBorrow(url.getParameter("test.on.borrow", true));
            config.setTestOnReturn(url.getParameter("test.on.return", false));
            config.setTestWhileIdle(url.getParameter("test.while.idle", false));
            if (url.getParameter("max.idle", 0) > 0) {
                config.setMaxIdle(url.getParameter("max.idle", 0));
            }
            if (url.getParameter("min.idle", 0) > 0) {
                config.setMinIdle(url.getParameter("min.idle", 0));
            }
            if (url.getParameter("max.total", 0) > 0) {
                config.setMaxTotal(url.getParameter("max.total", 0));
            }
            if (url.getParameter("max.wait", 0) > 0) {
                config.setMaxWaitMillis((long)url.getParameter("min.wait", 0));
            }
            if (url.getParameter("num.tests.per.eviction.run", 0) > 0) {
                config.setNumTestsPerEvictionRun(url.getParameter("num.tests.per.eviction.run", 0));
            }
            if (url.getParameter("time.between.eviction.runs.millis", 0) > 0) {
                config.setTimeBetweenEvictionRunsMillis((long)url.getParameter("time.between.eviction.runs.millis", 0));
            }
            if (url.getParameter("min.evictable.idle.time.millis", 0) > 0) {
                config.setMinEvictableIdleTimeMillis((long)url.getParameter("min.evictable.idle.time.millis", 0));
            }
            final JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)config, url.getHost(), url.getPort(6379), url.getParameter("timeout", 1000));
            final int expiry = url.getParameter("expiry", 0);
            final String get = url.getParameter("get", "get");
            final String set = url.getParameter("set", Map.class.equals(type) ? "put" : "set");
            final String delete = url.getParameter("delete", Map.class.equals(type) ? "remove" : "delete");
            return new AbstractInvoker<T>(type, url){

                @Override
                protected Result doInvoke(Invocation invocation) throws Throwable {
                    Jedis resource = null;
                    try {
                        resource = jedisPool.getResource();
                        if (get.equals(invocation.getMethodName())) {
                            if (invocation.getArguments().length != 1) {
                                throw new IllegalArgumentException("The redis get method arguments mismatch, must only one arguments. interface: " + type.getName() + ", method: " + invocation.getMethodName() + ", url: " + url);
                            }
                            byte[] value = resource.get(String.valueOf(invocation.getArguments()[0]).getBytes());
                            if (value == null) {
                                RpcResult rpcResult = new RpcResult();
                                return rpcResult;
                            }
                            ObjectInput oin = RedisProtocol.this.getSerialization(url).deserialize(url, new ByteArrayInputStream(value));
                            RpcResult t = new RpcResult(oin.readObject());
                            return t;
                        }
                        if (set.equals(invocation.getMethodName())) {
                            if (invocation.getArguments().length != 2) {
                                throw new IllegalArgumentException("The redis set method arguments mismatch, must be two arguments. interface: " + type.getName() + ", method: " + invocation.getMethodName() + ", url: " + url);
                            }
                            byte[] key = String.valueOf(invocation.getArguments()[0]).getBytes();
                            ByteArrayOutputStream output = new ByteArrayOutputStream();
                            ObjectOutput value = RedisProtocol.this.getSerialization(url).serialize(url, output);
                            value.writeObject(invocation.getArguments()[1]);
                            resource.set(key, output.toByteArray());
                            if (expiry > 1000) {
                                resource.expire(key, expiry / 1000);
                            }
                            RpcResult rpcResult = new RpcResult();
                            return rpcResult;
                        }
                        if (delete.equals(invocation.getMethodName())) {
                            if (invocation.getArguments().length != 1) {
                                throw new IllegalArgumentException("The redis delete method arguments mismatch, must only one arguments. interface: " + type.getName() + ", method: " + invocation.getMethodName() + ", url: " + url);
                            }
                            resource.del(String.valueOf(invocation.getArguments()[0]).getBytes());
                            RpcResult key = new RpcResult();
                            return key;
                        }
                        try {
                            throw new UnsupportedOperationException("Unsupported method " + invocation.getMethodName() + " in redis service.");
                        }
                        catch (Throwable t) {
                            JahhanException re = new JahhanException("Failed to invoke redis service method. interface: " + type.getName() + ", method: " + invocation.getMethodName() + ", url: " + url + ", cause: " + t.getMessage(), t);
                            if (t instanceof TimeoutException || t instanceof SocketTimeoutException) {
                                re.setCode(952);
                            } else if (t instanceof JedisConnectionException || t instanceof IOException) {
                                re.setCode(951);
                            } else if (t instanceof JedisDataException) {
                                re.setCode(955);
                            }
                            throw re;
                        }
                    }
                    finally {
                        if (resource != null) {
                            try {
                                jedisPool.returnResource(resource);
                            }
                            catch (Throwable t) {
                                log.warn("returnResource error: " + t.getMessage(), t);
                            }
                        }
                    }
                }

                @Override
                public void destroy() {
                    super.destroy();
                    try {
                        jedisPool.destroy();
                    }
                    catch (Throwable e) {
                        log.warn(e.getMessage(), e);
                    }
                }
            };
        }
        catch (Throwable t) {
            throw new JahhanException("Failed to refer redis service. interface: " + type.getName() + ", url: " + url + ", cause: " + t.getMessage(), t);
        }
    }
}

