/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.merger;

import com.frameworkx.common.extension.utils.ExtensionExtendUtil;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jahhan.com.alibaba.dubbo.common.utils.ReflectUtils;
import net.jahhan.extension.merger.ArrayMerger;
import net.jahhan.spi.Merger;

public class MergerFactory {
    private static final ConcurrentMap<Class<?>, Merger<?>> mergerCache = new ConcurrentHashMap();

    public static <T> Merger<T> getMerger(Class<T> returnType) {
        Merger result;
        if (returnType.isArray()) {
            Class<?> type = returnType.getComponentType();
            result = (Merger)mergerCache.get(type);
            if (result == null) {
                MergerFactory.loadMergers();
                result = (Merger)mergerCache.get(type);
            }
            if (result == null && !type.isPrimitive()) {
                result = ArrayMerger.INSTANCE;
            }
        } else {
            result = (Merger)mergerCache.get(returnType);
            if (result == null) {
                MergerFactory.loadMergers();
                result = (Merger)mergerCache.get(returnType);
            }
        }
        return result;
    }

    static void loadMergers() {
        Set<String> names = ExtensionExtendUtil.getSupportedExtensions(Merger.class);
        for (String name : names) {
            Merger m = ExtensionExtendUtil.getExtension(Merger.class, name);
            mergerCache.putIfAbsent(ReflectUtils.getGenericClass(m.getClass()), m);
        }
    }
}

