/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.filter;

import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.validation.Validator;
import com.frameworkx.annotation.Activate;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.exception.JahhanException;
import net.jahhan.spi.Filter;
import net.jahhan.spi.Validation;

@Activate(group={"consumer", "provider"}, order=10000)
@Extension(value="validation")
@Singleton
public class ValidationFilter
implements Filter {
    @Inject
    private Validation validation;

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws JahhanException {
        if (this.validation != null && !invocation.getMethodName().startsWith("$")) {
            try {
                Validator validator = this.validation.getValidator(invoker.getUrl());
                if (validator != null) {
                    validator.validate(invocation.getMethodName(), invocation.getParameterTypes(), invocation.getArguments());
                }
            }
            catch (JahhanException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new JahhanException(t.getMessage(), t);
            }
        }
        return invoker.invoke(invocation);
    }
}

