/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.filter;

import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.filter.tps.DefaultTPSLimiter;
import com.alibaba.dubbo.rpc.filter.tps.TPSLimiter;
import com.frameworkx.annotation.Activate;
import javax.inject.Singleton;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.exception.JahhanException;
import net.jahhan.spi.Filter;

@Activate(group={"provider"}, value={"tps"})
@Extension(value="tpslimit")
@Singleton
public class TpsLimitFilter
implements Filter {
    private final TPSLimiter tpsLimiter = new DefaultTPSLimiter();

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws JahhanException {
        if (!this.tpsLimiter.isAllowable(invoker.getUrl(), invocation)) {
            throw new JahhanException(new StringBuilder(64).append("Failed to invoke service ").append(invoker.getInterface().getName()).append(".").append(invocation.getMethodName()).append(" because exceed max service tps.").toString());
        }
        return invoker.invoke(invocation);
    }
}

