/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.filter;

import com.alibaba.dubbo.common.beanutil.JavaBeanAccessor;
import com.alibaba.dubbo.common.beanutil.JavaBeanDescriptor;
import com.alibaba.dubbo.common.beanutil.JavaBeanSerializeUtil;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcInvocation;
import com.alibaba.dubbo.rpc.RpcResult;
import com.alibaba.dubbo.rpc.service.GenericException;
import com.alibaba.dubbo.rpc.support.ProtocolUtils;
import com.frameworkx.annotation.Activate;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.inject.Singleton;
import net.jahhan.com.alibaba.dubbo.common.utils.PojoUtils;
import net.jahhan.com.alibaba.dubbo.common.utils.ReflectUtils;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.exception.JahhanException;
import net.jahhan.spi.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"consumer"}, value={"generic"}, order=20000)
@Extension(value="genericimpl")
@Singleton
public class GenericImplFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(GenericImplFilter.class);
    private static final Class<?>[] GENERIC_PARAMETER_TYPES = new Class[]{String.class, String[].class, Object[].class};

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws JahhanException {
        String generic = invoker.getUrl().getParameter("generic");
        if (ProtocolUtils.isGeneric(generic) && !"$invoke".equals(invocation.getMethodName()) && invocation instanceof RpcInvocation) {
            Result result;
            block30: {
                Object[] args;
                RpcInvocation invocation2 = (RpcInvocation)invocation;
                String methodName = invocation2.getMethodName();
                Class<?>[] parameterTypes = invocation2.getParameterTypes();
                Object[] arguments = invocation2.getArguments();
                String[] types = new String[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    types[i] = ReflectUtils.getName(parameterTypes[i]);
                }
                if (ProtocolUtils.isBeanGenericSerialization(generic)) {
                    args = new Object[arguments.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        args[i] = JavaBeanSerializeUtil.serialize(arguments[i], JavaBeanAccessor.METHOD);
                    }
                } else {
                    args = PojoUtils.generalize(arguments);
                }
                invocation2.setMethodName("$invoke");
                invocation2.setParameterTypes(GENERIC_PARAMETER_TYPES);
                invocation2.setArguments(new Object[]{methodName, types, args});
                result = invoker.invoke(invocation2);
                if (!result.hasException()) {
                    Object value = result.getValue();
                    try {
                        Method method = invoker.getInterface().getMethod(methodName, parameterTypes);
                        if (ProtocolUtils.isBeanGenericSerialization(generic)) {
                            if (value == null) {
                                return new RpcResult(value);
                            }
                            if (value instanceof JavaBeanDescriptor) {
                                return new RpcResult(JavaBeanSerializeUtil.deserialize((JavaBeanDescriptor)value));
                            }
                            throw new JahhanException(new StringBuilder(64).append("The type of result value is ").append(value.getClass().getName()).append(" other than ").append(JavaBeanDescriptor.class.getName()).append(", and the result is ").append(value).toString());
                        }
                        return new RpcResult(PojoUtils.realize(value, method.getReturnType(), method.getGenericReturnType()));
                    }
                    catch (NoSuchMethodException e) {
                        throw new JahhanException(e.getMessage(), (Throwable)e);
                    }
                }
                if (result.getException() instanceof GenericException) {
                    GenericException exception = (GenericException)result.getException();
                    try {
                        String className = exception.getExceptionClass();
                        Class<?> clazz = ReflectUtils.forName(className);
                        Throwable targetException = null;
                        Throwable lastException = null;
                        try {
                            targetException = (Throwable)clazz.newInstance();
                        }
                        catch (Throwable e) {
                            lastException = e;
                            for (Constructor<?> constructor : clazz.getConstructors()) {
                                try {
                                    targetException = (Throwable)constructor.newInstance(new Object[constructor.getParameterTypes().length]);
                                    break;
                                }
                                catch (Throwable e1) {
                                    lastException = e1;
                                }
                            }
                        }
                        if (targetException != null) {
                            try {
                                Field field = Throwable.class.getDeclaredField("detailMessage");
                                if (!field.isAccessible()) {
                                    field.setAccessible(true);
                                }
                                field.set(targetException, exception.getExceptionMessage());
                            }
                            catch (Throwable e) {
                                log.warn(e.getMessage(), e);
                            }
                            result = new RpcResult(targetException);
                            break block30;
                        }
                        if (lastException != null) {
                            throw lastException;
                        }
                    }
                    catch (Throwable e) {
                        throw new JahhanException("Can not deserialize exception " + exception.getExceptionClass() + ", message: " + exception.getExceptionMessage(), e);
                    }
                }
            }
            return result;
        }
        if (invocation.getMethodName().equals("$invoke") && invocation.getArguments() != null && invocation.getArguments().length == 3 && ProtocolUtils.isGeneric(generic)) {
            Object[] args = (Object[])invocation.getArguments()[2];
            if (ProtocolUtils.isJavaGenericSerialization(generic)) {
                for (Object arg : args) {
                    if (byte[].class == arg.getClass()) continue;
                    this.error(byte[].class.getName(), arg.getClass().getName());
                }
            } else if (ProtocolUtils.isBeanGenericSerialization(generic)) {
                for (Object arg : args) {
                    if (arg instanceof JavaBeanDescriptor) continue;
                    this.error(JavaBeanDescriptor.class.getName(), arg.getClass().getName());
                }
            }
            ((RpcInvocation)invocation).setAttachment("generic", invoker.getUrl().getParameter("generic"));
        }
        return invoker.invoke(invocation);
    }

    private void error(String expected, String actual) throws JahhanException {
        throw new JahhanException(new StringBuilder(32).append("Generic serialization [").append("nativejava").append("] only support message type ").append(expected).append(" and your message type is ").append(actual).toString());
    }
}

