/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.filter;

import com.alibaba.dubbo.common.beanutil.JavaBeanAccessor;
import com.alibaba.dubbo.common.beanutil.JavaBeanDescriptor;
import com.alibaba.dubbo.common.beanutil.JavaBeanSerializeUtil;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcInvocation;
import com.alibaba.dubbo.rpc.RpcResult;
import com.alibaba.dubbo.rpc.service.GenericException;
import com.alibaba.dubbo.rpc.support.ProtocolUtils;
import com.frameworkx.annotation.Activate;
import com.frameworkx.common.extension.utils.ExtensionExtendUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.inject.Singleton;
import net.jahhan.com.alibaba.dubbo.common.io.UnsafeByteArrayInputStream;
import net.jahhan.com.alibaba.dubbo.common.io.UnsafeByteArrayOutputStream;
import net.jahhan.com.alibaba.dubbo.common.utils.PojoUtils;
import net.jahhan.com.alibaba.dubbo.common.utils.ReflectUtils;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.common.extension.utils.StringUtils;
import net.jahhan.exception.JahhanException;
import net.jahhan.spi.Filter;
import net.jahhan.spi.Serialization;

@Activate(group={"provider"}, order=-20000)
@Extension(value="generic")
@Singleton
public class GenericFilter
implements Filter {
    @Override
    public Result invoke(Invoker<?> invoker, Invocation inv) throws JahhanException {
        if (inv.getMethodName().equals("$invoke") && inv.getArguments() != null && inv.getArguments().length == 3 && !ProtocolUtils.isGeneric(invoker.getUrl().getParameter("generic"))) {
            String name = ((String)inv.getArguments()[0]).trim();
            String[] types = (String[])inv.getArguments()[1];
            Object[] args = (Object[])inv.getArguments()[2];
            try {
                int i;
                String generic;
                Method method = ReflectUtils.findMethodByMethodSignature(invoker.getInterface(), name, types);
                Class<?>[] params = method.getParameterTypes();
                if (args == null) {
                    args = new Object[params.length];
                }
                if (StringUtils.isEmpty(generic = inv.getAttachment("generic")) || ProtocolUtils.isDefaultGenericSerialization(generic)) {
                    args = PojoUtils.realize(args, params, method.getGenericParameterTypes());
                } else if (ProtocolUtils.isJavaGenericSerialization(generic)) {
                    for (i = 0; i < args.length; ++i) {
                        if (byte[].class == args[i].getClass()) {
                            try {
                                UnsafeByteArrayInputStream is = new UnsafeByteArrayInputStream((byte[])args[i]);
                                args[i] = ExtensionExtendUtil.getExtension(Serialization.class, "nativejava").deserialize(null, is).readObject();
                                continue;
                            }
                            catch (Exception e) {
                                throw new JahhanException("Deserialize argument [" + (i + 1) + "] failed.", (Throwable)e);
                            }
                        }
                        throw new JahhanException(new StringBuilder(32).append("Generic serialization [").append("nativejava").append("] only support message type ").append(byte[].class).append(" and your message type is ").append(args[i].getClass()).toString());
                    }
                } else if (ProtocolUtils.isBeanGenericSerialization(generic)) {
                    for (i = 0; i < args.length; ++i) {
                        if (!(args[i] instanceof JavaBeanDescriptor)) {
                            throw new JahhanException(new StringBuilder(32).append("Generic serialization [").append("bean").append("] only support message type ").append(JavaBeanDescriptor.class.getName()).append(" and your message type is ").append(args[i].getClass().getName()).toString());
                        }
                        args[i] = JavaBeanSerializeUtil.deserialize((JavaBeanDescriptor)args[i]);
                    }
                }
                Result result = invoker.invoke(new RpcInvocation(method, args, inv.getAttachments()));
                if (result.hasException() && !(result.getException() instanceof GenericException)) {
                    return new RpcResult(new GenericException(result.getException()));
                }
                if (ProtocolUtils.isJavaGenericSerialization(generic)) {
                    try {
                        UnsafeByteArrayOutputStream os = new UnsafeByteArrayOutputStream(512);
                        ExtensionExtendUtil.getExtension(Serialization.class, "nativejava").serialize(null, os).writeObject(result.getValue());
                        return new RpcResult(os.toByteArray());
                    }
                    catch (IOException e) {
                        throw new JahhanException("Serialize result failed.", (Throwable)e);
                    }
                }
                if (ProtocolUtils.isBeanGenericSerialization(generic)) {
                    return new RpcResult(JavaBeanSerializeUtil.serialize(result.getValue(), JavaBeanAccessor.METHOD));
                }
                return new RpcResult(PojoUtils.generalize(result.getValue()));
            }
            catch (NoSuchMethodException e) {
                throw new JahhanException(e.getMessage(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new JahhanException(e.getMessage(), (Throwable)e);
            }
        }
        return invoker.invoke(inv);
    }
}

