/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.filter;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcStatus;
import com.frameworkx.annotation.Activate;
import java.util.concurrent.Semaphore;
import javax.inject.Singleton;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.exception.JahhanException;
import net.jahhan.spi.Filter;

@Activate(group={"provider"}, value={"executes"})
@Extension(value="executelimit")
@Singleton
public class ExecuteLimitFilter
implements Filter {
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws JahhanException {
        RpcStatus count;
        URL url = invoker.getUrl();
        String methodName = invocation.getMethodName();
        Semaphore executesLimit = null;
        boolean acquireResult = false;
        int max = url.getMethodParameter(methodName, "executes", 0);
        if (max > 0 && (executesLimit = (count = RpcStatus.getStatus(url, invocation.getMethodName())).getSemaphore(max)) != null && !(acquireResult = executesLimit.tryAcquire())) {
            throw new JahhanException("Failed to invoke method " + invocation.getMethodName() + " in provider " + url + ", cause: The service using threads greater than <dubbo:service executes=\"" + max + "\" /> limited.");
        }
        long begin = System.currentTimeMillis();
        boolean isSuccess = true;
        RpcStatus.beginCount(url, methodName);
        try {
            Result result;
            Result result2 = result = invoker.invoke(invocation);
            return result2;
        }
        catch (Throwable t) {
            isSuccess = false;
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new JahhanException("unexpected exception when ExecuteLimitFilter", t);
        }
        finally {
            RpcStatus.endCount(url, methodName, System.currentTimeMillis() - begin, isSuccess);
            if (acquireResult) {
                executesLimit.release();
            }
        }
    }
}

