/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.filter;

import com.alibaba.dubbo.common.utils.ConfigUtils;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcInvocation;
import com.frameworkx.annotation.Activate;
import java.util.UUID;
import javax.inject.Singleton;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.context.BaseVariable;
import net.jahhan.exception.JahhanException;
import net.jahhan.spi.Filter;

@Activate(group={"consumer"}, order=-10000)
@Extension(value="consumercontext")
@Singleton
public class ConsumerContextFilter
implements Filter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws JahhanException {
        String host = ConfigUtils.getProperty("dubbo.protocol.host", NetUtils.getLocalHost());
        RpcContext.getContext().setInvoker(invoker).setInvocation(invocation).setLocalAddress(host, 0).setRemoteAddress(invoker.getUrl().getHost(), invoker.getUrl().getPort());
        RpcContext.getContext().setAttachment("request_id", UUID.randomUUID().toString());
        RpcContext.getContext().setAttachment("chain_id", BaseVariable.getBaseVariable().getChainId());
        if (invocation instanceof RpcInvocation) {
            ((RpcInvocation)invocation).setInvoker(invoker);
        }
        try {
            Result result = invoker.invoke(invocation);
            return result;
        }
        finally {
            RpcContext.getContext().clearAttachments();
        }
    }
}

