/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.filter;

import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcResult;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.inject.Singleton;
import net.jahhan.com.alibaba.dubbo.common.utils.CompatibleTypeUtils;
import net.jahhan.com.alibaba.dubbo.common.utils.PojoUtils;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.exception.JahhanException;
import net.jahhan.spi.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension(value="compatible")
@Singleton
public class CompatibleFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CompatibleFilter.class);

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws JahhanException {
        Object value;
        Result result = invoker.invoke(invocation);
        if (!invocation.getMethodName().startsWith("$") && !result.hasException() && (value = result.getValue()) != null) {
            try {
                Object newValue;
                Method method = invoker.getInterface().getMethod(invocation.getMethodName(), invocation.getParameterTypes());
                Class<?> type = method.getReturnType();
                String serialization = invoker.getUrl().getParameter("serialization");
                if ("json".equals(serialization) || "fastjson".equals(serialization)) {
                    Type gtype = method.getGenericReturnType();
                    newValue = PojoUtils.realize(value, type, gtype);
                } else {
                    newValue = !type.isInstance(value) ? (PojoUtils.isPojo(type) ? PojoUtils.realize(value, type) : CompatibleTypeUtils.compatibleTypeConvert(value, type)) : value;
                }
                if (newValue != value) {
                    result = new RpcResult(newValue);
                }
            }
            catch (Throwable t) {
                log.warn(t.getMessage(), t);
            }
        }
        return result;
    }
}

