/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.filter;

import com.alibaba.dubbo.cache.Cache;
import com.alibaba.dubbo.common.utils.ConfigUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcResult;
import com.frameworkx.annotation.Activate;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.exception.JahhanException;
import net.jahhan.spi.CacheFactory;
import net.jahhan.spi.Filter;

@Activate(group={"consumer", "provider"}, value={"cache"})
@Extension(value="cache")
@Singleton
public class CacheFilter
implements Filter {
    @Inject
    private CacheFactory cacheFactory;

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws JahhanException {
        Cache cache;
        if (this.cacheFactory != null && ConfigUtils.isNotEmpty(invoker.getUrl().getMethodParameter(invocation.getMethodName(), "cache")) && (cache = this.cacheFactory.getCache(invoker.getUrl().addParameter("method", invocation.getMethodName()))) != null) {
            String key = StringUtils.toArgumentString(invocation.getArguments());
            if (cache != null && key != null) {
                Object value = cache.get(key);
                if (value != null) {
                    return new RpcResult(value);
                }
                Result result = invoker.invoke(invocation);
                if (!result.hasException()) {
                    cache.put(key, result.getValue());
                }
                return result;
            }
        }
        return invoker.invoke(invocation);
    }
}

