/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.crypto;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Singleton;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.common.extension.utils.Base64Util;
import net.jahhan.exception.JahhanException;
import net.jahhan.spi.common.ICrypto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension(value="aes")
@Singleton
public class AESCrypto
implements ICrypto {
    private static final Logger log = LoggerFactory.getLogger(AESCrypto.class);

    @Override
    public String encrypt(String content, String key) {
        try {
            byte[] contentBytes = content.getBytes("UTF-8");
            SecretKeySpec skeySpec = new SecretKeySpec(key.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, skeySpec);
            byte[] encryptResult = cipher.doFinal(contentBytes);
            String result = Base64Util.encode(encryptResult);
            result = result.replace("\n", "").replace("\r", "");
            return result;
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6\u5f02\u5e38\uff1acontext:" + content + ",key:" + key, (Throwable)e);
            JahhanException.throwException(917, "\u52a0\u5bc6\u5f02\u5e38\uff1acontext:" + content + ",key:" + key, e);
            return null;
        }
    }

    public String encrypt(String content, String key, String mode) {
        try {
            byte[] contentBytes = content.getBytes("UTF-8");
            SecretKeySpec skeySpec = new SecretKeySpec(key.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance(mode);
            cipher.init(1, skeySpec);
            byte[] encryptResult = cipher.doFinal(contentBytes);
            String result = Base64Util.encode(encryptResult);
            result = result.replace("\n", "").replace("\r", "");
            return result;
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6\u5f02\u5e38\uff1acontext:" + content + ",key:" + key, (Throwable)e);
            JahhanException.throwException(917, "\u52a0\u5bc6\u5f02\u5e38\uff1acontext:" + content + ",key:" + key, e);
            return null;
        }
    }

    @Override
    public String decrypt(String content, String key) {
        String result = null;
        byte[] decryptResult = null;
        try {
            byte[] contentBytes = Base64Util.decode(content);
            SecretKeySpec skeySpec = new SecretKeySpec(key.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, skeySpec);
            decryptResult = cipher.doFinal(contentBytes);
            if (decryptResult != null) {
                result = new String(decryptResult, "UTF-8");
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u5f02\u5e38\uff1acontext:" + content + ",key:" + key, (Throwable)e);
            JahhanException.throwException(918, "\u89e3\u5bc6\u5f02\u5e38\uff1acontext:" + content + ",key:" + key, e);
        }
        return result;
    }

    public String decrypt(String content, String key, String mode) {
        String result = null;
        byte[] decryptResult = null;
        try {
            byte[] contentBytes = Base64Util.decode(content);
            SecretKeySpec skeySpec = new SecretKeySpec(key.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance(mode);
            cipher.init(2, skeySpec);
            decryptResult = cipher.doFinal(contentBytes);
            if (decryptResult != null) {
                result = new String(decryptResult, "UTF-8");
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u5f02\u5e38\uff1acontext:" + content + ",key:" + key, (Throwable)e);
            JahhanException.throwException(918, "\u89e3\u5bc6\u5f02\u5e38\uff1acontext:" + content + ",key:" + key, e);
        }
        return result;
    }
}

