/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.cluster;

import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.cluster.Directory;
import com.alibaba.dubbo.rpc.cluster.support.AbstractClusterInvoker;
import java.util.List;
import javax.inject.Singleton;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.exception.JahhanException;
import net.jahhan.spi.Cluster;
import net.jahhan.spi.LoadBalance;

@Extension(value="available")
@Singleton
public class AvailableCluster
implements Cluster {
    public static final String NAME = "available";

    @Override
    public <T> Invoker<T> join(Directory<T> directory) throws JahhanException {
        return new AbstractClusterInvoker<T>(directory){

            @Override
            public Result doInvoke(Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws JahhanException {
                for (Invoker invoker : invokers) {
                    if (!invoker.isAvailable()) continue;
                    return invoker.invoke(invocation);
                }
                throw new JahhanException("No provider available in " + invokers);
            }
        };
    }
}

