/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.context;

import com.google.inject.Injector;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.jahhan.context.Node;
import net.jahhan.context.ThreadLocalUtil;
import net.jahhan.context.VariableContext;

@Singleton
public class BaseContext {
    public static BaseContext CTX;
    @Inject
    private Injector injector;
    @Inject
    private ThreadLocalUtil<VariableContext> threadLocalUtil;
    private Node node = Node.getInstance();
    private Map<String, Thread> chainMap = new ConcurrentHashMap<String, Thread>();
    private String token;
    private String innerSecrityKey;
    private String appPubKey;
    private String thirdPubKey;
    private String browserSecrityKey;
    private String browserPubKey;
    private String firstSingleToken;

    public BaseContext() {
        if (null == CTX) {
            CTX = this;
        }
    }

    public void setChain(String chainId, Thread t) {
        this.chainMap.put(chainId, t);
    }

    public Thread getChainThread(String chainId) {
        return this.chainMap.get(chainId);
    }

    public void removeChain(String chainId) {
        this.chainMap.remove(chainId);
    }

    public boolean containsChain(String chainId) {
        return this.chainMap.containsKey(chainId);
    }

    public Injector getInjector() {
        return this.injector;
    }

    public ThreadLocalUtil<VariableContext> getThreadLocalUtil() {
        return this.threadLocalUtil;
    }

    public VariableContext getVariableContext() {
        return this.threadLocalUtil.getValue();
    }

    public Node getNode() {
        return this.node;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getInnerSecrityKey() {
        return this.innerSecrityKey;
    }

    public void setInnerSecrityKey(String innerSecrityKey) {
        this.innerSecrityKey = innerSecrityKey;
    }

    public String getAppPubKey() {
        return this.appPubKey;
    }

    public void setAppPubKey(String appPubKey) {
        this.appPubKey = appPubKey;
    }

    public String getThirdPubKey() {
        return this.thirdPubKey;
    }

    public void setThirdPubKey(String thirdPubKey) {
        this.thirdPubKey = thirdPubKey;
    }

    public String getBrowserSecrityKey() {
        return this.browserSecrityKey;
    }

    public void setBrowserSecrityKey(String browserSecrityKey) {
        this.browserSecrityKey = browserSecrityKey;
    }

    public String getBrowserPubKey() {
        return this.browserPubKey;
    }

    public void setBrowserPubKey(String browserPubKey) {
        this.browserPubKey = browserPubKey;
    }

    public String getFirstSingleToken() {
        return this.firstSingleToken;
    }

    public void setFirstSingleToken(String firstSingleToken) {
        this.firstSingleToken = firstSingleToken;
    }
}

