/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.common.extension.utils.properties;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import net.jahhan.api.PropertiesResetter;
import net.jahhan.common.extension.annotation.Order;
import net.jahhan.common.extension.annotation.PropertiesFile;
import net.jahhan.common.extension.utils.ClassScaner;
import net.jahhan.exception.JahhanException;

public class PropertiesInit {
    private static Map<String, Properties> propertiesMap = new HashMap<String, Properties>();
    private static Map<String, Map<Integer, PropertiesResetter>> propertiesResetterMap = new HashMap<String, Map<Integer, PropertiesResetter>>();

    public static void reset(String fileName, Properties properties) {
        Map<Integer, PropertiesResetter> propertiesResetterTreeMap = propertiesResetterMap.get(fileName);
        if (null != propertiesResetterTreeMap) {
            Set<Map.Entry<Integer, PropertiesResetter>> propertiesTreeEntrySet = propertiesResetterTreeMap.entrySet();
            for (Map.Entry<Integer, PropertiesResetter> entry : propertiesTreeEntrySet) {
                PropertiesResetter propertiesResetter = entry.getValue();
                properties = propertiesResetter.init(properties);
            }
        }
        propertiesMap.put(fileName, properties);
    }

    public static Properties get(String fileName, Properties properties) {
        Properties propertiesInMap = propertiesMap.get(fileName);
        if (null != propertiesInMap) {
            return propertiesInMap;
        }
        PropertiesInit.reset(fileName, properties);
        return properties;
    }

    static {
        try {
            String[] packages = new String[]{"net.jahhan.properties"};
            List<String> classNameList = new ClassScaner().parse(packages);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (String className : classNameList) {
                Class<?> clazz = classLoader.loadClass(className);
                if (!clazz.isAnnotationPresent(PropertiesFile.class) || !PropertiesResetter.class.isAssignableFrom(clazz)) continue;
                PropertiesFile propertiesFile = clazz.getAnnotation(PropertiesFile.class);
                PropertiesResetter propertiesResetter = (PropertiesResetter)clazz.newInstance();
                propertiesResetter.init(new Properties());
                Order order = clazz.getAnnotation(Order.class);
                Map<Integer, PropertiesResetter> map = propertiesResetterMap.get(propertiesFile.value());
                if (null == map) {
                    map = new TreeMap<Integer, PropertiesResetter>(new Comparator<Integer>(){

                        @Override
                        public int compare(Integer a, Integer b) {
                            return b - a;
                        }
                    });
                    propertiesResetterMap.put(propertiesFile.value(), map);
                }
                if (null != order) {
                    map.put(order.value(), propertiesResetter);
                    continue;
                }
                map.put(0, propertiesResetter);
            }
            Set<Map.Entry<String, Map<Integer, PropertiesResetter>>> propertiesEntrySet = propertiesResetterMap.entrySet();
            for (Map.Entry<String, Map<Integer, PropertiesResetter>> propertiesEntryMap : propertiesEntrySet) {
                Map<Integer, PropertiesResetter> value = propertiesEntryMap.getValue();
                Set<Map.Entry<Integer, PropertiesResetter>> propertiesTreeEntrySet = value.entrySet();
                Properties properties = new Properties();
                for (Map.Entry<Integer, PropertiesResetter> entry : propertiesTreeEntrySet) {
                    PropertiesResetter propertiesResetter = entry.getValue();
                    properties = propertiesResetter.init(properties);
                }
                propertiesMap.put(propertiesEntryMap.getKey(), properties);
            }
        }
        catch (Exception e) {
            JahhanException.throwException(998, "\u914d\u7f6e\u6587\u4ef6\u9519\u8bef", e);
        }
    }
}

