/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.common.extension.utils;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.jahhan.context.BaseContext;

public abstract class ExtensionUtil {
    protected static volatile Map<Class<?>, Map<Class<?>, String>> extensionCacheClassNameMap = new ConcurrentHashMap();

    public static <T> T getExtension(Class<T> type, String name) {
        Injector injector = BaseContext.CTX.getInjector();
        return (T)injector.getInstance(Key.get(type, (Annotation)Names.named((String)name)));
    }

    public static <T> T getExtensionDirect(Class<T> type, String name) {
        Injector injector = BaseContext.CTX.getInjector();
        Object instance = injector.getInstance(Key.get(type, (Annotation)Names.named((String)("$" + name))));
        return (T)instance;
    }

    public static <T> T getExtension(Class<T> type) {
        Injector injector = BaseContext.CTX.getInjector();
        return (T)injector.getInstance(type);
    }

    public static <T> Set<String> getSupportedExtensions(Class<T> type) {
        Map<Class<?>, String> map = extensionCacheClassNameMap.get(type);
        if (null != map) {
            Collection<String> values = map.values();
            HashSet<String> re = new HashSet<String>();
            for (String value : values) {
                re.add(value);
            }
            return re;
        }
        return null;
    }

    public static <T> String getExtensionName(Class<T> type, Class<? extends Object> extension) {
        Map<Class<?>, String> map = extensionCacheClassNameMap.get(type);
        if (null != map) {
            return map.get(extension);
        }
        return null;
    }

    public static <T> boolean hasExtension(Class<T> type, String extension) {
        Map<Class<?>, String> map = extensionCacheClassNameMap.get(type);
        if (null != map) {
            return map.containsValue(extension);
        }
        return false;
    }

    public static Map<Class<?>, Map<Class<?>, String>> getExtensionCacheClassNameMap() {
        return extensionCacheClassNameMap;
    }
}

