/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.common.extension.utils;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import net.jahhan.common.extension.utils.LogUtil;

public class ClassScaner {
    public List<String> parse(String[] packageNames) {
        ArrayList<String> classNameList = new ArrayList<String>(240);
        if (packageNames != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (String packageName : packageNames) {
                String packagePath = packageName.replaceAll("\\.", "/");
                try {
                    Enumeration<URL> eUrl = classLoader.getResources(packagePath);
                    while (eUrl.hasMoreElements()) {
                        URL url = eUrl.nextElement();
                        String filePath = url.getFile();
                        if (filePath.indexOf("src/test/") != -1 || filePath.indexOf("src/main/") != -1) continue;
                        File file = new File(url.getPath());
                        this.parseFile(classNameList, file, packagePath, url);
                    }
                }
                catch (IOException ex) {
                    LogUtil.error("parse \u89e3\u6790\u6307\u5b9a\u7684\u5305\u540d\u51fa\u73b0\u5f02\u5e38", ex);
                }
            }
        } else {
            LogUtil.error("parse \u6ca1\u6709\u8f93\u51fa\u6307\u5b9a\u7684\u5305\u8def\u5f84");
        }
        return classNameList;
    }

    private void parseFile(List<String> classNameList, File file, String packagePath, URL url) {
        if (file.isDirectory()) {
            File[] subFiles;
            for (File subFile : subFiles = file.listFiles()) {
                this.parseFile(classNameList, subFile, packagePath, url);
            }
        } else if (file.getPath().contains(".class")) {
            this.findClass(classNameList, file, packagePath);
        } else if (file.getPath().contains(".jar")) {
            this.findClassInJar(classNameList, url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findClassInJar(List<String> classNameList, URL url) {
        String urlFile = url.getFile();
        int separatorIndex = urlFile.indexOf("!/");
        String rootEntryPath = "";
        if (separatorIndex != -1) {
            rootEntryPath = urlFile.substring(separatorIndex + "!/".length());
        }
        JarFile jarFile = null;
        try {
            jarFile = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> jarEntryEnum = jarFile.entries();
            while (jarEntryEnum.hasMoreElements()) {
                String className;
                JarEntry jarEntry = jarEntryEnum.nextElement();
                if (!jarEntry.getName().endsWith(".class") || !jarEntry.getName().startsWith(rootEntryPath) || classNameList.contains(className = jarEntry.getName().replaceAll("/", ".").substring(0, jarEntry.getName().length() - 6))) continue;
                classNameList.add(className);
            }
        }
        catch (IOException ex) {
            LogUtil.error("findClassInJar \u627e\u4e0d\u5230\u76f8\u5e94\u7684jar\u6216\u8005class", ex);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ex) {
                    LogUtil.error("findClassInJar \u5173\u95edjarFile\u51fa\u73b0\u5f02\u5e38", ex);
                }
            }
        }
    }

    private void findClass(List<String> classNameList, File file, String packagePath) {
        String absolutePath = file.getAbsolutePath().replaceAll("\\\\", "/");
        int index = absolutePath.indexOf(packagePath);
        String className = absolutePath.substring(index);
        className = className.replaceAll("/", ".");
        if (!classNameList.contains(className = className.substring(0, className.length() - 6))) {
            classNameList.add(className);
        }
    }

    public static Set<String> findResourceByPathRule(String rule, String ... parentPaths) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        try {
            ClassLoader cl = ClassScaner.class.getClassLoader();
            for (String parentPath : parentPaths) {
                Enumeration<URL> resourceUrls;
                Enumeration<URL> enumeration = resourceUrls = cl != null ? cl.getResources(parentPath) : ClassLoader.getSystemResources(parentPath);
                while (resourceUrls.hasMoreElements()) {
                    URL url = resourceUrls.nextElement();
                    Set<Object> fileNameSet = new LinkedHashSet();
                    Pattern pattern = Pattern.compile(rule);
                    if (url.toString().startsWith("jar")) {
                        fileNameSet = ClassScaner.findPathMatchingJarResources(url, pattern);
                    } else if (url.toString().startsWith("file")) {
                        fileNameSet = ClassScaner.findPathMatchingFiles(url, pattern);
                    }
                    for (String string : fileNameSet) {
                        result.add(parentPath + string);
                    }
                }
            }
        }
        catch (Exception e) {
            LogUtil.error("scan resource", e);
        }
        return result;
    }

    private static Set<String> findPathMatchingFiles(URL url, Pattern pattern) {
        String[] fileNames;
        LinkedHashSet<String> result = new LinkedHashSet<String>(8);
        File folder = new File(url.getFile());
        for (String fileName : fileNames = folder.list()) {
            if (!pattern.matcher(fileName).matches()) continue;
            result.add(fileName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> findPathMatchingJarResources(URL url, Pattern pattern) throws IOException {
        String rootEntryPath;
        String jarFileUrl;
        JarFile jarFile;
        URLConnection con = url.openConnection();
        boolean newJarFile = false;
        if (con instanceof JarURLConnection) {
            JarURLConnection jarCon = (JarURLConnection)con;
            jarFile = jarCon.getJarFile();
            jarFileUrl = jarCon.getJarFileURL().toExternalForm();
            JarEntry jarEntry = jarCon.getJarEntry();
            rootEntryPath = jarEntry != null ? jarEntry.getName() : "";
        } else {
            String urlFile = url.getFile();
            try {
                int separatorIndex = urlFile.indexOf("!/");
                if (separatorIndex != -1) {
                    jarFileUrl = urlFile.substring(0, separatorIndex);
                    rootEntryPath = urlFile.substring(separatorIndex + "!/".length());
                    jarFile = new JarFile(jarFileUrl);
                } else {
                    jarFile = new JarFile(urlFile);
                    jarFileUrl = urlFile;
                    rootEntryPath = "";
                }
                newJarFile = true;
            }
            catch (ZipException ex) {
                ex.printStackTrace();
                return Collections.emptySet();
            }
        }
        try {
            if (!"".equals(rootEntryPath) && !rootEntryPath.endsWith("/")) {
                rootEntryPath = rootEntryPath + "/";
            }
            LinkedHashSet<String> result = new LinkedHashSet<String>(8);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String relativePath;
                JarEntry entry = entries.nextElement();
                String entryPath = entry.getName();
                if (!entryPath.startsWith(rootEntryPath) || !pattern.matcher(relativePath = entryPath.substring(rootEntryPath.length())).matches() || relativePath.indexOf("/") != -1) continue;
                result.add(relativePath);
            }
            LinkedHashSet<String> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            if (newJarFile) {
                jarFile.close();
            }
        }
    }

    public static Set<Class> findClassInPackage(String rule, Package ... pkgs) {
        HashSet<String> pathSet = new HashSet<String>();
        for (Package pkg : pkgs) {
            pathSet.add(pkg.getName().replace('.', '/') + "/");
        }
        String[] paths = pathSet.toArray(new String[pathSet.size()]);
        return ClassScaner.findClassInPath(rule, paths);
    }

    public static Set<Class> findClassInPath(String rule, String ... paths) {
        HashSet<Class> result = new HashSet<Class>();
        String classNameRule = rule + "\\.class";
        Set<String> classPaths = ClassScaner.findResourceByPathRule(classNameRule, paths);
        for (String classPath : classPaths) {
            String className = classPath.substring(0, classPath.length() - 6).replace('/', '.');
            try {
                result.add(Class.forName(className));
            }
            catch (Exception e) {
                LogUtil.error("scan resource1", e);
            }
        }
        return result;
    }
}

