/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.common.extension.utils;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.jahhan.common.extension.utils.JsonUtil;
import net.jahhan.common.extension.utils.apache.convert.DateConverter;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;

public class BeanTools {
    private static ConvertUtilsBean convertUtils = BeanUtilsBean.getInstance().getConvertUtils();

    public static <S, D> D convertType(Object obj, Class<S> srcClass, Class<D> destClass) {
        if (srcClass.equals(destClass)) {
            return (D)JsonUtil.copyObject(obj);
        }
        Converter converter = convertUtils.lookup(srcClass, destClass);
        return (D)converter.convert(destClass, obj);
    }

    public static Map<String, Object> toMap(Object model) {
        Field[] fields;
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Field field : fields = model.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                m.put(field.getName(), field.get(model));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return m;
    }

    public static void copyFromMap(Object dest, Map src) {
        List<Field> fields = BeanTools.getSuperClassField(dest.getClass());
        for (Field field : fields) {
            try {
                field.setAccessible(true);
                String name = field.getName();
                Object value = src.get(name);
                if (value == null || name.equals("serialVersionUID")) continue;
                field.set(dest, BeanTools.convertType(value, value.getClass(), field.getType()));
            }
            catch (Exception exception) {}
        }
    }

    private static List<Field> getSuperClassField(Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        ArrayList<Field> fields = new ArrayList<Field>();
        if (null != superclass) {
            fields.addAll(BeanTools.getSuperClassField(superclass));
        }
        Field[] declaredFields = clazz.getDeclaredFields();
        fields.addAll(Arrays.asList(declaredFields));
        return fields;
    }

    public static void copyBean(Object dest, Object src) {
        Map<String, Object> srcMap = null;
        srcMap = src instanceof Map ? (Map<String, Object>)src : BeanTools.toMap(src);
        BeanTools.copyFromMap(dest, srcMap);
    }

    public static <T> T[] values(Class<T> c) {
        try {
            return (Object[])c.getMethod("values", new Class[0]).invoke(c, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] objectToData(Object obj) {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bOut);
            out.writeObject(obj);
            out.close();
            bOut.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getUuid() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    static {
        convertUtils.register((Converter)new DateConverter(), Date.class);
        convertUtils.register((Converter)new DateConverter(), java.sql.Date.class);
    }
}

