/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.common.extension.constant;

import java.util.Properties;
import net.jahhan.common.extension.constant.InjectType;
import net.jahhan.common.extension.utils.PropertiesUtil;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BaseConfiguration.class);
    public static String FRAMEWORK_PATH;
    public static String SERVICE_PATH;
    public static String SYSTEM_ERROR_CODE_LEVEL;
    public static String SERVICE;
    public static boolean IS_DEBUG;
    public static Integer GLOBAL_EXPIRE_SECOND;
    public static String INTERFACE_SUFFIX;
    public static InjectType INJECT_TYPE;

    static {
        SYSTEM_ERROR_CODE_LEVEL = "JAHHAN";
        SERVICE = "";
        IS_DEBUG = false;
        INTERFACE_SUFFIX = "Intf";
        INJECT_TYPE = InjectType.guice;
        Properties property = PropertiesUtil.getProperties("base");
        try {
            FRAMEWORK_PATH = property.getProperty("path.framework");
            SERVICE_PATH = property.getProperty("path.service");
            IS_DEBUG = Boolean.parseBoolean(property.getProperty("debug", "false"));
            SERVICE = property.getProperty("serviceCode");
            String globalExpireSecond = property.getProperty("globalExpireSecond", "7200");
            int ttl = NumberUtils.toInt((String)globalExpireSecond, (int)-1);
            if (ttl > 0) {
                GLOBAL_EXPIRE_SECOND = ttl;
            }
            INTERFACE_SUFFIX = property.getProperty("interface.suffix", "Intf");
            INJECT_TYPE = InjectType.valueOf(property.getProperty("inject.type", InjectType.guice.toString()));
        }
        catch (Exception ex) {
            log.error("\u52a0\u8f7d\u7cfb\u7edfbase.properties\u914d\u7f6e\u51fa\u9519", (Throwable)ex);
            throw new RuntimeException("\u52a0\u8f7d\u7cfb\u7edfbase.properties\u914d\u7f6e\u51fa\u9519");
        }
    }
}

