/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.com.alibaba.dubbo.common.serialize.support.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import net.jahhan.com.alibaba.dubbo.common.serialize.support.kryo.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompatibleKryo
extends Kryo {
    private static final Logger log = LoggerFactory.getLogger(CompatibleKryo.class);

    public Serializer getDefaultSerializer(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (!type.isArray() && !ReflectionUtils.checkZeroArgConstructor(type)) {
            if (log.isWarnEnabled()) {
                log.warn(type + " has no zero-arg constructor and this will affect the serialization performance");
            }
            return new JavaSerializer();
        }
        return super.getDefaultSerializer(type);
    }
}

