/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkx.common.extension.utils;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.ConfigUtils;
import com.frameworkx.annotation.Activate;
import com.frameworkx.annotation.Adaptive;
import com.frameworkx.common.extension.utils.extension.ActivateComparator;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.jahhan.common.extension.utils.ExtensionUtil;
import net.jahhan.context.BaseContext;

public abstract class ExtensionExtendUtil
extends ExtensionUtil {
    private static final Map<Class<?>, Map<String, Activate>> cachedActivates = new ConcurrentHashMap();

    public static <T> T getExtension(Class<T> type, String name) {
        Injector injector = BaseContext.CTX.getInjector();
        return (T)injector.getInstance(Key.get(type, (Annotation)Names.named((String)name)));
    }

    public static <T> T getExtensionDirect(Class<T> type, String name) {
        Injector injector = BaseContext.CTX.getInjector();
        Object instance = injector.getInstance(Key.get(type, (Annotation)Names.named((String)("$" + name))));
        return (T)instance;
    }

    public static <T> T getExtension(Class<T> type) {
        Injector injector = BaseContext.CTX.getInjector();
        return (T)injector.getInstance(type);
    }

    public static <T> T getAdaptiveExtension(Class<T> type) {
        Injector injector = BaseContext.CTX.getInjector();
        try {
            return (T)injector.getInstance(Key.get(type, Adaptive.class));
        }
        catch (Exception e) {
            throw new IllegalStateException("fail to create adaptive instance: " + e.toString(), e);
        }
    }

    public static <T> Set<String> getSupportedExtensions(Class<T> type) {
        Map map = (Map)extensionCacheClassNameMap.get(type);
        if (null != map) {
            Collection values = map.values();
            HashSet<String> re = new HashSet<String>();
            for (String value : values) {
                re.add(value);
            }
            return re;
        }
        return null;
    }

    public static <T> String getExtensionName(Class<T> type, Class<? extends Object> extension) {
        Map map = (Map)extensionCacheClassNameMap.get(type);
        if (null != map) {
            return (String)map.get(extension);
        }
        return null;
    }

    public static <T> boolean hasExtension(Class<T> type, String extension) {
        Map map = (Map)extensionCacheClassNameMap.get(type);
        if (null != map) {
            return map.containsValue(extension);
        }
        return false;
    }

    public static <T> List<T> getActivateExtension(Class<T> type, URL url, String key) {
        return ExtensionExtendUtil.getActivateExtension(type, url, key, null);
    }

    public static <T> List<T> getActivateExtension(Class<T> type, URL url, String[] values) {
        return ExtensionExtendUtil.getActivateExtension(type, url, values, null);
    }

    public static <T> List<T> getActivateExtension(Class<T> type, URL url, String key, String group) {
        String value = url.getParameter(key);
        return ExtensionExtendUtil.getActivateExtension(type, url, value == null || value.length() == 0 ? null : Constants.COMMA_SPLIT_PATTERN.split(value), group);
    }

    public static <T> List<T> getActivateExtension(Class<T> type, URL url, String[] values, String group) {
        List<Object> names;
        ArrayList<Object> exts = new ArrayList<Object>();
        List<Object> list = names = values == null ? new ArrayList(0) : Arrays.asList(values);
        if (!names.contains("-default")) {
            Map<String, Activate> map = cachedActivates.get(type);
            if (null != map) {
                for (Map.Entry<String, Activate> entry : map.entrySet()) {
                    String name = entry.getKey();
                    Activate activate = entry.getValue();
                    if (!ExtensionExtendUtil.isMatchGroup(group, activate.group())) continue;
                    T ext = ExtensionExtendUtil.getExtension(type, name);
                    if (names.contains(name) || names.contains("-" + name) || !ExtensionExtendUtil.isActive(activate, url)) continue;
                    exts.add(ext);
                }
            }
            Collections.sort(exts, ActivateComparator.COMPARATOR);
        }
        ArrayList<T> usrs = new ArrayList<T>();
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            if (name.startsWith("-") || names.contains("-" + name)) continue;
            if ("default".equals(name)) {
                if (usrs.size() <= 0) continue;
                exts.addAll(0, usrs);
                usrs.clear();
                continue;
            }
            T ext = ExtensionExtendUtil.getExtension(type, name);
            usrs.add(ext);
        }
        if (usrs.size() > 0) {
            exts.addAll(usrs);
        }
        return exts;
    }

    private static boolean isMatchGroup(String group, String[] groups) {
        if (group == null || group.length() == 0) {
            return true;
        }
        if (groups != null && groups.length > 0) {
            for (String g : groups) {
                if (!group.equals(g)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isActive(Activate activate, URL url) {
        String[] keys = activate.value();
        if (keys == null || keys.length == 0) {
            return true;
        }
        for (String key : keys) {
            for (Map.Entry<String, String> entry : url.getParameters().entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                if (!k.equals(key) && !k.endsWith("." + key) || !ConfigUtils.isNotEmpty(v)) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<Class<?>, Map<String, Activate>> getCachedActivates() {
        return cachedActivates;
    }
}

