/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkx.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;

@Singleton
public class ClusterMessageHolder {
    private Map<String, Map<String, String>> serviceMap = new ConcurrentHashMap<String, Map<String, String>>();

    public void addServer(String service, String nodeId, String value) {
        Map<String, String> serverMap = null;
        serverMap = !this.serviceMap.containsKey(service) ? new HashMap<String, String>() : this.serviceMap.get(service);
        serverMap.put(nodeId, value);
        this.serviceMap.put(service, serverMap);
    }

    public void deleteServer(String service, String nodeId) {
        if (this.serviceMap.containsKey(service)) {
            Map<String, String> serverMap = this.serviceMap.get(service);
            serverMap.remove(nodeId);
            this.serviceMap.put(service, serverMap);
        }
    }

    public Map<String, Map<String, String>> getServiceMap() {
        return this.serviceMap;
    }

    public boolean contains(String nodeId) {
        Set<String> keySet = this.serviceMap.keySet();
        for (String service : keySet) {
            Map<String, String> map = this.serviceMap.get(service);
            if (!map.containsKey(nodeId)) continue;
            return true;
        }
        return false;
    }
}

