/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.proxy;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcResult;
import java.lang.reflect.InvocationTargetException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.core.Response;
import net.jahhan.common.extension.utils.JsonUtil;
import net.jahhan.exception.ExceptionMessage;
import net.jahhan.exception.JahhanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProxyInvoker<T>
implements Invoker<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractProxyInvoker.class);
    private final T proxy;
    private final Class<T> type;
    private final URL url;

    public AbstractProxyInvoker(T proxy, Class<T> type, URL url) {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy == null");
        }
        if (type == null) {
            throw new IllegalArgumentException("interface == null");
        }
        if (!type.isInstance(proxy)) {
            throw new IllegalArgumentException(proxy.getClass().getName() + " not implement interface " + type);
        }
        this.proxy = proxy;
        this.type = type;
        this.url = url;
    }

    @Override
    public Class<T> getInterface() {
        return this.type;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void destroy() {
    }

    @Override
    public Result invoke(Invocation invocation) throws JahhanException {
        try {
            return new RpcResult(this.doInvoke(this.proxy, invocation.getMethodName(), invocation.getParameterTypes(), invocation.getArguments()));
        }
        catch (InvocationTargetException e) {
            log.debug(e.getMessage(), (Throwable)e);
            int httpStatus = 500;
            int code = 999;
            String message = e.getTargetException().getMessage();
            Throwable targetException = e.getTargetException();
            Throwable cause = e.getCause().getCause();
            if (targetException instanceof JahhanException) {
                JahhanException exception = (JahhanException)targetException;
                httpStatus = exception.getExceptionMessage().getHttpStatus();
                code = exception.getExceptionMessage().getCode();
                message = exception.getExceptionMessage().getMessage();
            }
            if (e.getTargetException() instanceof InternalServerErrorException) {
                Response response = ((ServerErrorException)e.getCause()).getResponse();
                String readEntity = (String)response.readEntity(String.class);
                ExceptionMessage serverException = JsonUtil.fromJson(readEntity.replace("\r", "").replace("\n", ""), ExceptionMessage.class);
                code = serverException.getCode();
                message = serverException.getMessage();
                httpStatus = serverException.getHttpStatus();
            }
            return new RpcResult(new JahhanException(httpStatus, code, message, cause));
        }
        catch (Throwable e) {
            throw new JahhanException("Failed to invoke remote proxy method " + invocation.getMethodName() + " to " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    protected abstract Object doInvoke(T var1, String var2, Class<?>[] var3, Object[] var4) throws Throwable;

    public String toString() {
        return this.getInterface() + " -> " + this.getUrl() == null ? " " : this.getUrl().toString();
    }
}

