/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.protocol.rest;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.rpc.protocol.rest.DubboResourceFactory;
import com.alibaba.dubbo.rpc.protocol.rest.RestServer;
import java.util.List;
import net.jahhan.common.extension.utils.ClassScaner;
import net.jahhan.common.extension.utils.PackageUtil;
import net.jahhan.common.extension.utils.StringUtils;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyDeployment;

public abstract class BaseRestServer
implements RestServer {
    @Override
    public void start(URL url) {
        this.getDeployment().getMediaTypeMappings().put("json", "application/json");
        this.getDeployment().getMediaTypeMappings().put("xml", "text/xml");
        String[] packages = PackageUtil.packages("rest.filter");
        List<String> classNameList = new ClassScaner().parse(packages);
        for (String className : classNameList) {
            this.getDeployment().getProviderClasses().add(className);
        }
        this.loadProviders(url.getParameter("extension", ""));
        this.doStart(url);
    }

    @Override
    public void deploy(Class resourceDef, Object resourceInstance, String contextPath) {
        if (StringUtils.isEmpty(contextPath)) {
            this.getDeployment().getRegistry().addResourceFactory((ResourceFactory)new DubboResourceFactory(resourceInstance, resourceDef));
        } else {
            this.getDeployment().getRegistry().addResourceFactory((ResourceFactory)new DubboResourceFactory(resourceInstance, resourceDef), contextPath);
        }
    }

    @Override
    public void undeploy(Class resourceDef) {
        this.getDeployment().getRegistry().removeRegistrations(resourceDef);
    }

    protected void loadProviders(String value) {
        for (String clazz : Constants.COMMA_SPLIT_PATTERN.split(value)) {
            if (StringUtils.isEmpty(clazz)) continue;
            this.getDeployment().getProviderClasses().add(clazz.trim());
        }
    }

    protected abstract ResteasyDeployment getDeployment();

    protected abstract void doStart(URL var1);
}

